/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BiIntPredicate;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.utils.internal.ThrowableUtils;
import javax.annotation.Nullable;

final class RetrySingle<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Single<T> original;
    private final BiIntPredicate<Throwable> shouldRetry;

    RetrySingle(Single<T> original, BiIntPredicate<Throwable> shouldRetry) {
        this.original = original;
        this.shouldRetry = shouldRetry;
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new RetrySubscriber<T>(new SequentialCancellable(), this, subscriber, 0, contextMap.copy(), contextProvider), contextMap, contextProvider);
    }

    private static final class RetrySubscriber<T>
    extends AbstractRetrySubscriber<T> {
        private final RetrySingle<T> retrySingle;
        private final ContextMap contextMap;
        private final AsyncContextProvider contextProvider;

        RetrySubscriber(SequentialCancellable sequentialCancellable, RetrySingle<T> retrySingle, SingleSource.Subscriber<? super T> target, int retryCount, ContextMap contextMap, AsyncContextProvider contextProvider) {
            super(sequentialCancellable, target, retryCount);
            this.retrySingle = retrySingle;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.target.onSuccess(result);
        }

        @Override
        public void onError(Throwable t) {
            boolean shouldRetry;
            try {
                shouldRetry = ((RetrySingle)this.retrySingle).shouldRetry.test(++this.retryCount, t);
            }
            catch (Throwable cause) {
                this.target.onError(ThrowableUtils.addSuppressed((Throwable)cause, (Throwable)t));
                return;
            }
            if (shouldRetry) {
                ((RetrySingle)this.retrySingle).original.delegateSubscribe(this, this.contextMap, this.contextProvider);
            } else {
                this.target.onError(t);
            }
        }
    }

    static abstract class AbstractRetrySubscriber<T>
    implements SingleSource.Subscriber<T> {
        final SequentialCancellable sequentialCancellable;
        final SingleSource.Subscriber<? super T> target;
        int retryCount;

        AbstractRetrySubscriber(SequentialCancellable sequentialCancellable, SingleSource.Subscriber<? super T> target, int retryCount) {
            this.sequentialCancellable = sequentialCancellable;
            this.target = target;
            this.retryCount = retryCount;
        }

        @Override
        public final void onSubscribe(Cancellable cancellable) {
            cancellable = this.decorate(cancellable);
            this.sequentialCancellable.nextCancellable(cancellable);
            if (this.retryCount == 0) {
                this.target.onSubscribe((Cancellable)this.sequentialCancellable);
            }
        }

        Cancellable decorate(Cancellable cancellable) {
            return cancellable;
        }
    }
}

