/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletableProcessor;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.DefaultCompositeCloseable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;

public final class AsyncCloseables {
    private AsyncCloseables() {
    }

    public static Completable closeAsyncGracefully(AsyncCloseable closable, long timeout, TimeUnit timeoutUnit) {
        return closable.closeAsyncGracefully().timeout(timeout, timeoutUnit).onErrorResume(TimeoutException.class, t -> closable.closeAsync());
    }

    public static ListenableAsyncCloseable emptyAsyncCloseable() {
        return new ListenableAsyncCloseable(){
            private final CompletableProcessor onClose = new CompletableProcessor();
            private final Completable closeAsync = new SubscribableCompletable(){

                @Override
                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    onClose.onComplete();
                    onClose.subscribeInternal(subscriber);
                }
            };

            @Override
            public Completable closeAsync() {
                return this.closeAsync;
            }

            @Override
            public Completable onClose() {
                return this.onClose;
            }
        };
    }

    public static ListenableAsyncCloseable toListenableAsyncCloseable(AsyncCloseable asyncCloseable) {
        return AsyncCloseables.toListenableAsyncCloseable(asyncCloseable, Function.identity());
    }

    public static ListenableAsyncCloseable toListenableAsyncCloseable(final AsyncCloseable asyncCloseable, final Function<Completable, Completable> onCloseDecorator) {
        return new ListenableAsyncCloseable(){
            private final CompletableProcessor onCloseProcessor = new CompletableProcessor();
            private final Completable onClose = (Completable)onCloseDecorator.apply(this.onCloseProcessor);

            @Override
            public Completable closeAsyncGracefully() {
                return new SubscribableCompletable(){

                    @Override
                    protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                        asyncCloseable.closeAsyncGracefully().subscribeInternal(onCloseProcessor);
                        onClose.subscribeInternal(subscriber);
                    }
                };
            }

            @Override
            public Completable onClose() {
                return this.onClose;
            }

            @Override
            public Completable closeAsync() {
                return new SubscribableCompletable(){

                    @Override
                    protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                        asyncCloseable.closeAsync().subscribeInternal(onCloseProcessor);
                        onClose.subscribeInternal(subscriber);
                    }
                };
            }
        };
    }

    public static ListenableAsyncCloseable toAsyncCloseable(CloseableResource closeableResource) {
        return new DefaultAsyncCloseable(closeableResource);
    }

    public static CompositeCloseable newCompositeCloseable() {
        return new DefaultCompositeCloseable();
    }

    private static abstract class SubscribableCompletable
    extends Completable
    implements CompletableSource {
        private SubscribableCompletable() {
        }

        @Override
        public final void subscribe(CompletableSource.Subscriber subscriber) {
            this.subscribeInternal(subscriber);
        }
    }

    private static final class DefaultAsyncCloseable
    implements ListenableAsyncCloseable {
        private static final int IDLE = 0;
        private static final int CLOSED_GRACEFULLY = 1;
        private static final int HARD_CLOSE = 2;
        private static final AtomicIntegerFieldUpdater<DefaultAsyncCloseable> closedUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultAsyncCloseable.class, "closed");
        private final CloseableResource closeableResource;
        private final CompletableProcessor onClose = new CompletableProcessor();
        private volatile int closed;

        DefaultAsyncCloseable(CloseableResource closeableResource) {
            this.closeableResource = closeableResource;
        }

        @Override
        public Completable closeAsync() {
            return new SubscribableCompletable(){

                @Override
                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    onClose.subscribeInternal(subscriber);
                    if (closedUpdater.getAndSet(this, 2) != 2) {
                        closeableResource.doClose(false).subscribeInternal(onClose);
                    }
                }
            };
        }

        @Override
        public Completable closeAsyncGracefully() {
            return new SubscribableCompletable(){

                @Override
                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    onClose.subscribeInternal(subscriber);
                    if (closedUpdater.compareAndSet(this, 0, 1)) {
                        closeableResource.doClose(true).subscribeInternal(onClose);
                    }
                }
            };
        }

        @Override
        public Completable onClose() {
            return this.onClose;
        }
    }

    @FunctionalInterface
    public static interface CloseableResource {
        public Completable doClose(boolean var1);
    }
}

