/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.AsciiBuffer;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import io.servicetalk.buffer.api.ReadOnlyBufferAllocators;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CharSequences {
    private static final int RADIX_10 = 10;
    private static final long PARSE_LONG_MIN = -922337203685477580L;

    private CharSequences() {
    }

    public static CharSequence newAsciiString(CharSequence input) {
        return CharSequences.newAsciiString(ReadOnlyBufferAllocators.DEFAULT_RO_ALLOCATOR.fromAscii(input));
    }

    public static CharSequence newAsciiString(Buffer input) {
        return new AsciiBuffer(input);
    }

    public static CharSequence emptyAsciiString() {
        return AsciiBuffer.EMPTY_ASCII_BUFFER;
    }

    private static boolean isAsciiString(CharSequence sequence) {
        return sequence.getClass() == AsciiBuffer.class;
    }

    @Nullable
    public static Buffer unwrapBuffer(CharSequence cs) {
        return CharSequences.isAsciiString(cs) ? ((AsciiBuffer)cs).unwrap() : null;
    }

    public static int forEachByte(CharSequence sequence, ByteProcessor visitor) {
        Objects.requireNonNull(sequence);
        if (CharSequences.isAsciiString(sequence)) {
            return ((AsciiBuffer)sequence).forEachByte(visitor);
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (visitor.process((byte)sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean contentEqualsIgnoreCase(@Nullable CharSequence a, @Nullable CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        if (a.getClass() == AsciiBuffer.class) {
            return ((AsciiBuffer)a).contentEqualsIgnoreCase(b);
        }
        return CharSequences.contentEqualsIgnoreCaseUnknownTypes(a, b);
    }

    public static boolean contentEquals(@Nullable CharSequence a, @Nullable CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        if (a.getClass() == AsciiBuffer.class) {
            return ((AsciiBuffer)a).contentEquals(b);
        }
        return CharSequences.contentEqualsUnknownTypes(a, b);
    }

    public static int indexOf(CharSequence sequence, char c, int fromIndex) {
        if (CharSequences.isAsciiString(sequence)) {
            return CharSequences.asciiStringIndexOf(sequence, c, fromIndex);
        }
        if (sequence instanceof String) {
            return ((String)sequence).indexOf(c, fromIndex);
        }
        for (int i = fromIndex; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int asciiStringIndexOf(CharSequence sequence, char c, int fromIndex) {
        return ((AsciiBuffer)sequence).indexOf(c, fromIndex);
    }

    public static int caseInsensitiveHashCode(CharSequence seq) {
        return CharSequences.isAsciiString(seq) ? seq.hashCode() : AsciiBuffer.hashCodeAscii(seq);
    }

    public static List<CharSequence> split(CharSequence input, char delimiter, boolean trim) {
        if (input.length() == 0) {
            return Collections.emptyList();
        }
        return trim ? CharSequences.splitWithTrim(input, CharSequences.isAsciiString(input), delimiter) : CharSequences.split0(input, CharSequences.isAsciiString(input), delimiter);
    }

    private static List<CharSequence> split0(CharSequence input, boolean isAscii, char delimiter) {
        int startIndex = 0;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>(4);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != delimiter) continue;
            result.add(CharSequences.subsequence(isAscii, input, startIndex, i));
            startIndex = i + 1;
        }
        if (input.length() - startIndex > 0) {
            result.add(CharSequences.subsequence(isAscii, input, startIndex, input.length()));
        } else {
            result.add(isAscii ? AsciiBuffer.EMPTY_ASCII_BUFFER : "");
        }
        return result;
    }

    private static List<CharSequence> splitWithTrim(CharSequence input, boolean isAscii, char delimiter) {
        int startIndex = -1;
        int endIndex = -1;
        boolean reset = true;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>(4);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != ' ' && c != delimiter) {
                endIndex = i + 1;
            }
            if (reset && c != ' ' && c != delimiter) {
                startIndex = i;
                reset = false;
                continue;
            }
            if (c != delimiter) continue;
            if (endIndex > startIndex) {
                result.add(CharSequences.subsequence(isAscii, input, startIndex, endIndex));
            } else {
                result.add(isAscii ? AsciiBuffer.EMPTY_ASCII_BUFFER : "");
            }
            startIndex = i + 1;
            endIndex = i + 1;
            reset = true;
        }
        if (startIndex != -1) {
            if (input.length() - startIndex > 0) {
                result.add(CharSequences.subsequence(isAscii, input, startIndex, endIndex));
            } else {
                result.add(isAscii ? AsciiBuffer.EMPTY_ASCII_BUFFER : "");
            }
        }
        return result;
    }

    private static CharSequence subsequence(boolean isAscii, CharSequence input, int start, int end) {
        return isAscii ? CharSequences.newAsciiString(((AsciiBuffer)input).unwrap().copy(start, end - start)) : input.subSequence(start, end);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || CharSequences.toLowerCase(a) == CharSequences.toLowerCase(b);
    }

    public static boolean equalsIgnoreCaseLower(char a, char lowerCaseChar) {
        return a == lowerCaseChar || CharSequences.toLowerCase(a) == lowerCaseChar;
    }

    private static char toLowerCase(char c) {
        return CharSequences.isUpperCase(c) ? (char)(c + 32) : c;
    }

    private static boolean isUpperCase(char value) {
        return value >= 'A' && value <= 'Z';
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string, int start, int length) {
        if (cs instanceof String && string instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, csStart, (String)string, start, length);
        }
        return CharSequences.regionMatchesCharSequences(cs, csStart, string, start, length, ignoreCase ? GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    private static boolean regionMatchesCharSequences(CharSequence cs, int csStart, CharSequence string, int start, int length, CharEqualityComparator charEqualityComparator) {
        if (csStart < 0 || length > cs.length() - csStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int csIndex = csStart;
        int csEnd = csIndex + length;
        int stringIndex = start;
        while (csIndex < csEnd) {
            char c2;
            char c1;
            if (charEqualityComparator.equals(c1 = cs.charAt(csIndex++), c2 = string.charAt(stringIndex++))) continue;
            return false;
        }
        return true;
    }

    static boolean contentEqualsUnknownTypes(CharSequence a, CharSequence b) {
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean contentEqualsIgnoreCaseUnknownTypes(CharSequence a, CharSequence b) {
        for (int i = 0; i < a.length(); ++i) {
            if (CharSequences.equalsIgnoreCase(a.charAt(i), b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static long parseLong(CharSequence cs) throws NumberFormatException {
        int length = cs.length();
        if (length <= 0) {
            throw new NumberFormatException("Illegal length of the CharSequence: " + length + " (expected > 0)");
        }
        if (CharSequences.isAsciiString(cs)) {
            return CharSequences.parseLong(((AsciiBuffer)cs).unwrap());
        }
        return CharSequences.parseLong(cs, length);
    }

    private static long parseLong(CharSequence cs, int length) {
        boolean negative;
        int i = 0;
        char firstCh = cs.charAt(i);
        boolean bl = negative = firstCh == '-';
        if ((negative || firstCh == '+') && ++i == length) {
            throw CharSequences.illegalInput(cs);
        }
        long result = 0L;
        while (i < length) {
            int digit;
            if ((digit = Character.digit(cs.charAt(i++), 10)) < 0) {
                throw CharSequences.illegalInput(cs);
            }
            if (-922337203685477580L > result) {
                throw CharSequences.illegalInput(cs);
            }
            long next = result * 10L - (long)digit;
            if (next > result) {
                throw CharSequences.illegalInput(cs);
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            throw CharSequences.illegalInput(cs);
        }
        return result;
    }

    private static long parseLong(Buffer buffer) {
        ParseLongByteProcessor bp = new ParseLongByteProcessor(buffer);
        buffer.forEachByte(bp);
        return bp.result();
    }

    private static NumberFormatException illegalInput(CharSequence cs) {
        return new NumberFormatException("Illegal input: \"" + cs + "\"");
    }

    private static NumberFormatException illegalInput(Buffer buffer) {
        return new NumberFormatException("Illegal input: \"" + buffer.toString(StandardCharsets.US_ASCII) + "\"");
    }

    private static final class ParseLongByteProcessor
    implements ByteProcessor {
        private final Buffer buffer;
        private long result;
        private boolean negative;
        private boolean sign;

        ParseLongByteProcessor(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public boolean process(byte value) {
            int digit;
            if (!this.sign) {
                this.sign = true;
                boolean bl = this.negative = value == 45;
                if (this.negative || value == 43) {
                    if (this.buffer.readableBytes() == 1) {
                        throw CharSequences.illegalInput(this.buffer);
                    }
                    return true;
                }
            }
            if ((digit = value - 48) < 0 || digit > 9) {
                throw CharSequences.illegalInput(this.buffer);
            }
            if (-922337203685477580L > this.result) {
                throw CharSequences.illegalInput(this.buffer);
            }
            long next = this.result * 10L - (long)digit;
            if (next > this.result) {
                throw CharSequences.illegalInput(this.buffer);
            }
            this.result = next;
            return true;
        }

        long result() {
            if (!this.negative) {
                this.result = -this.result;
                if (this.result < 0L) {
                    throw CharSequences.illegalInput(this.buffer);
                }
            }
            return this.result;
        }
    }

    private static final class GeneralCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final GeneralCaseInsensitiveCharEqualityComparator INSTANCE = new GeneralCaseInsensitiveCharEqualityComparator();

        private GeneralCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return a == b;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

