/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class StringUtils {
    private StringUtils() {
    }

    static String sanitizeIdentifier(String v, boolean firstToLower) {
        if (StringUtils.isNullOrEmpty(v)) {
            throw new IllegalArgumentException("java identifier must have length >= 1");
        }
        StringBuilder sb = new StringBuilder(v.length());
        sb.append(firstToLower ? Character.toLowerCase(v.charAt(0)) : Character.toUpperCase(v.charAt(0)));
        boolean afterUnderscore = false;
        for (int i = 1; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '_') {
                afterUnderscore = true;
                continue;
            }
            sb.append(afterUnderscore ? Character.toUpperCase(c) : c);
            afterUnderscore = false;
        }
        return sb.toString();
    }

    static boolean isNotNullNorEmpty(@Nullable String v) {
        return v != null && !v.isEmpty();
    }

    static boolean isNullOrEmpty(@Nullable String v) {
        return v == null || v.isEmpty();
    }

    static Map<String, String> parseOptions(String parameters) {
        HashMap<String, String> options = new HashMap<String, String>();
        int begin = 0;
        while (begin < parameters.length() && begin >= 0) {
            String option;
            int delim = parameters.indexOf(44, begin);
            if (delim > begin) {
                option = parameters.substring(begin, delim);
                begin = delim + 1;
            } else {
                option = parameters.substring(begin);
                begin = -1;
            }
            int equals = option.indexOf(61);
            if (equals > 0) {
                options.put(option.substring(0, equals), option.substring(equals + 1));
                continue;
            }
            options.put(option, null);
        }
        return options;
    }
}

