/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.javapoet.ClassName;
import io.servicetalk.grpc.protoc.FileDescriptor;
import io.servicetalk.grpc.protoc.GenerationContext;
import io.servicetalk.grpc.protoc.Generator;
import io.servicetalk.grpc.protoc.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class Main {
    private static final String TYPE_NAME_SUFFIX_OPTION = "typeNameSuffix";

    private Main() {
    }

    public static void main(String ... args) throws IOException {
        Main.safeGenerate(PluginProtos.CodeGeneratorRequest.parseFrom((InputStream)System.in)).writeTo((OutputStream)System.out);
    }

    private static PluginProtos.CodeGeneratorResponse safeGenerate(PluginProtos.CodeGeneratorRequest request) {
        try {
            return Main.generate(request);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(1024);
            sw.append("ServiceTalk code generation failed: ");
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
            }
            return PluginProtos.CodeGeneratorResponse.newBuilder().setError(sw.toString()).build();
        }
    }

    private static PluginProtos.CodeGeneratorResponse generate(PluginProtos.CodeGeneratorRequest request) {
        PluginProtos.CodeGeneratorResponse.Builder responseBuilder = PluginProtos.CodeGeneratorResponse.newBuilder();
        HashSet filesToGenerate = new HashSet(request.getFileToGenerateList());
        Map optionsMap = request.hasParameter() ? StringUtils.parseOptions(request.getParameter()) : Collections.emptyMap();
        String typeSuffixValue = (String)optionsMap.get(TYPE_NAME_SUFFIX_OPTION);
        List fileDescriptors = request.getProtoFileList().stream().map(protoFile -> new FileDescriptor((DescriptorProtos.FileDescriptorProto)protoFile, typeSuffixValue)).collect(Collectors.toList());
        Map<String, ClassName> messageTypesMap = fileDescriptors.stream().map(FileDescriptor::messageTypesMap).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        fileDescriptors.stream().filter(f -> filesToGenerate.contains(f.protoFileName())).forEach(f -> {
            Generator generator = new Generator((GenerationContext)f, messageTypesMap);
            f.protoServices().forEach(generator::generate);
            f.writeTo(responseBuilder);
        });
        return responseBuilder.build();
    }
}

