/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.servicetalk.grpc.protoc.GenerationContext;
import io.servicetalk.grpc.protoc.StringUtils;
import io.servicetalk.grpc.protoc.Types;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

final class Generator {
    private final GenerationContext context;
    private final Map<String, ClassName> messageTypesMap;

    Generator(GenerationContext context, Map<String, ClassName> messageTypesMap) {
        this.context = context;
        this.messageTypesMap = messageTypesMap;
    }

    void generate(DescriptorProtos.ServiceDescriptorProto serviceProto) {
        State state = new State(serviceProto);
        TypeSpec.Builder serviceClassBuilder = this.context.newServiceClassBuilder(serviceProto);
        this.addSerializationProviderInit(state, serviceClassBuilder);
        this.addServiceRpcInterfaces(state, serviceClassBuilder);
        this.addServiceInterfaces(state, serviceClassBuilder);
        this.addServiceFilter(state, serviceClassBuilder);
        this.addServiceFilterFactory(state, serviceClassBuilder);
        this.addServiceFactory(state, serviceClassBuilder);
        this.addClientMetadata(state, serviceClassBuilder);
        this.addClientInterfaces(state, serviceClassBuilder);
        this.addClientFilter(state, serviceClassBuilder);
        this.addClientFilterFactory(state, serviceClassBuilder);
        this.addClientFactory(state, serviceClassBuilder);
    }

    private void addSerializationProviderInit(State state, TypeSpec.Builder serviceClassBuilder) {
        CodeBlock.Builder staticInitBlockBuilder = CodeBlock.builder().addStatement("$T builder = new $T()", Types.ProtoBufSerializationProviderBuilder, Types.ProtoBufSerializationProviderBuilder).addStatement("builder.supportedMessageEncodings($L)", "supportedEncodings");
        Stream.concat(state.serviceProto.getMethodList().stream().filter(DescriptorProtos.MethodDescriptorProto::hasInputType).map(DescriptorProtos.MethodDescriptorProto::getInputType), state.serviceProto.getMethodList().stream().filter(DescriptorProtos.MethodDescriptorProto::hasOutputType).map(DescriptorProtos.MethodDescriptorProto::getOutputType)).distinct().map(this.messageTypesMap::get).forEach(t -> staticInitBlockBuilder.addStatement("$L.registerMessageType($T.class, $T.parser())", "builder", t, t));
        staticInitBlockBuilder.addStatement("return $L.build()", "builder").build();
        serviceClassBuilder.addMethod(MethodSpec.methodBuilder("initSerializationProvider").addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns(Types.GrpcSerializationProvider).addParameter(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addCode(staticInitBlockBuilder.build()).build());
    }

    private void addServiceRpcInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        state.serviceRpcInterfaces = new ArrayList<RpcInterface>(2 * state.serviceProto.getMethodCount());
        state.serviceProto.getMethodList().forEach(methodProto -> {
            String name = this.context.deconflictJavaTypeName(StringUtils.sanitizeIdentifier(methodProto.getName(), false) + "Rpc");
            FieldSpec.Builder pathSpecBuilder = FieldSpec.builder(String.class, "PATH", new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", this.context.methodPath(state.serviceProto, (DescriptorProtos.MethodDescriptorProto)methodProto));
            TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder(name).addAnnotation(FunctionalInterface.class).addModifiers(Modifier.PUBLIC).addField(pathSpecBuilder.build()).addMethod(this.newRpcMethodSpec((DescriptorProtos.MethodDescriptorProto)methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE), (__, b) -> b.addModifiers(Modifier.ABSTRACT).addParameter(Types.GrpcServiceContext, "ctx", new Modifier[0]))).addSuperinterface(Types.GrpcService);
            if (methodProto.hasOptions() && methodProto.getOptions().getDeprecated()) {
                interfaceSpecBuilder.addAnnotation(Deprecated.class);
            }
            TypeSpec interfaceSpec = interfaceSpecBuilder.build();
            state.serviceRpcInterfaces.add(new RpcInterface((DescriptorProtos.MethodDescriptorProto)methodProto, false, ClassName.bestGuess(name)));
            serviceClassBuilder.addType(interfaceSpec);
        });
        ArrayList<RpcInterface> asyncRpcInterfaces = new ArrayList<RpcInterface>(state.serviceRpcInterfaces);
        asyncRpcInterfaces.forEach(rpcInterface -> {
            DescriptorProtos.MethodDescriptorProto methodProto = rpcInterface.methodProto;
            String name = this.context.deconflictJavaTypeName("Blocking" + rpcInterface.className.simpleName());
            FieldSpec.Builder pathSpecBuilder = FieldSpec.builder(String.class, "PATH", new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
            pathSpecBuilder.initializer("$T.$L", rpcInterface.className, "PATH");
            TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder(name).addAnnotation(FunctionalInterface.class).addModifiers(Modifier.PUBLIC).addField(pathSpecBuilder.build()).addMethod(this.newRpcMethodSpec(methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE), (__, b) -> b.addModifiers(Modifier.ABSTRACT).addParameter(Types.GrpcServiceContext, "ctx", new Modifier[0]))).addSuperinterface(Types.BlockingGrpcService);
            if (methodProto.hasOptions() && methodProto.getOptions().getDeprecated()) {
                interfaceSpecBuilder.addAnnotation(Deprecated.class);
            }
            TypeSpec interfaceSpec = interfaceSpecBuilder.build();
            state.serviceRpcInterfaces.add(new RpcInterface(methodProto, true, ClassName.bestGuess(name)));
            serviceClassBuilder.addType(interfaceSpec);
        });
    }

    private void addServiceInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        TypeSpec interfaceSpec = this.newServiceInterfaceSpec(state, false);
        state.serviceClass = ClassName.bestGuess(interfaceSpec.name);
        serviceClassBuilder.addType(interfaceSpec);
        interfaceSpec = this.newServiceInterfaceSpec(state, true);
        state.blockingServiceClass = ClassName.bestGuess(interfaceSpec.name);
        serviceClassBuilder.addType(interfaceSpec);
    }

    private void addServiceFilter(State state, TypeSpec.Builder serviceClassBuilder) {
        state.serviceFilterClass = state.serviceClass.peerClass(state.serviceClass.simpleName() + "Filter");
        TypeSpec.Builder classSpecBuilder = Generator.newFilterDelegateCommonMethods(state.serviceFilterClass, state.serviceClass);
        state.serviceProto.getMethodList().forEach(methodProto -> classSpecBuilder.addMethod(this.newRpcMethodSpec((DescriptorProtos.MethodDescriptorProto)methodProto, EnumSet.noneOf(NewRpcMethodFlag.class), (n, b) -> b.addAnnotation(Override.class).addParameter(Types.GrpcServiceContext, "ctx", Modifier.FINAL).addStatement("return $L.$L($L, $L)", "delegate", n, "ctx", "request"))));
        serviceClassBuilder.addType(classSpecBuilder.build());
    }

    private void addServiceFilterFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        state.serviceFilterFactoryClass = state.serviceFilterClass.peerClass(state.serviceFilterClass.simpleName() + "Factory");
        serviceClassBuilder.addType(TypeSpec.interfaceBuilder(state.serviceFilterFactoryClass).addModifiers(Modifier.PUBLIC).addSuperinterface(ParameterizedTypeName.get(Types.GrpcServiceFilterFactory, state.serviceFilterClass, state.serviceClass)).build());
    }

    private void addServiceFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        ClassName serviceFactoryClass = state.serviceClass.peerClass("ServiceFactory");
        ClassName builderClass = serviceFactoryClass.nestedClass("Builder");
        ClassName serviceFromRoutesClass = builderClass.nestedClass(state.serviceClass.simpleName() + "FromRoutes");
        TypeSpec.Builder serviceBuilderSpecBuilder = TypeSpec.classBuilder("Builder").addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).addField(FieldSpec.builder(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addModifiers(Modifier.PRIVATE).build()).superclass(ParameterizedTypeName.get(Types.GrpcRoutes, state.serviceClass)).addType(this.newServiceFromRoutesClassSpec(serviceFromRoutesClass, state.serviceRpcInterfaces, state.serviceClass)).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("this.$L = java.util.Collections.emptySet()", "supportedEncodings").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addStatement("this.$L = $L", "supportedEncodings", "supportedEncodings").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addStatement("super($L)", "strategyFactory").addStatement("this.$L = java.util.Collections.emptySet()", "supportedEncodings").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addParameter(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addStatement("super($L)", "strategyFactory").addStatement("this.$L = $L", "supportedEncodings", "supportedEncodings").build()).addMethod(MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC).returns(serviceFactoryClass).addStatement("return new $T(this)", serviceFactoryClass).build()).addMethod(MethodSpec.methodBuilder("newServiceFromRoutes").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(serviceFromRoutesClass).addParameter(Types.AllGrpcRoutes, "routes", Modifier.FINAL).addStatement("return new $T($L)", serviceFromRoutesClass, "routes").build());
        state.serviceRpcInterfaces.forEach(rpcInterface -> {
            ClassName inClass = this.messageTypesMap.get(rpcInterface.methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(rpcInterface.methodProto.getOutputType());
            String routeName = Generator.routeName(rpcInterface.methodProto);
            String methodName = routeName + (rpcInterface.blocking ? "Blocking" : "");
            String addRouteMethodName = Generator.addRouteMethodName(rpcInterface.methodProto, rpcInterface.blocking);
            ClassName routeInterfaceClass = Generator.routeInterfaceClass(rpcInterface.methodProto, rpcInterface.blocking);
            serviceBuilderSpecBuilder.addMethod(MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addParameter(rpcInterface.className, "rpc", Modifier.FINAL).returns(builderClass).addStatement("$L($T.$L, $L.getClass(), $S, $L.wrap($L::$L, $L), $T.class, $T.class, $L($L))", addRouteMethodName, rpcInterface.className, "PATH", "rpc", routeName, routeInterfaceClass, "rpc", routeName, "rpc", inClass, outClass, "initSerializationProvider", "supportedEncodings").addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcExecutionStrategy, "strategy", Modifier.FINAL).addParameter(rpcInterface.className, "rpc", Modifier.FINAL).returns(builderClass).addStatement("$L($T.$L, $L, $L.wrap($L::$L, $L), $T.class, $T.class, $L($L))", addRouteMethodName, rpcInterface.className, "PATH", "strategy", routeInterfaceClass, "rpc", routeName, "rpc", inClass, outClass, "initSerializationProvider", "supportedEncodings").addStatement("return this", new Object[0]).build());
        });
        MethodSpec.Builder registerRoutesMethodSpecBuilder = MethodSpec.methodBuilder("registerRoutes").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).addParameter(state.serviceClass, "service", Modifier.FINAL);
        state.serviceProto.getMethodList().stream().map(Generator::routeName).forEach(n -> registerRoutesMethodSpecBuilder.addStatement("$L($L)", n, "service"));
        TypeSpec serviceBuilderType = serviceBuilderSpecBuilder.addMethod(registerRoutesMethodSpecBuilder.build()).build();
        TypeSpec.Builder serviceFactoryClassSpecBuilder = TypeSpec.classBuilder(serviceFactoryClass).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).superclass(ParameterizedTypeName.get(Types.GrpcServiceFactory, state.serviceFilterClass, state.serviceClass, state.serviceFilterFactoryClass)).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addStatement("super(new $T().$L)", builderClass, Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addParameter(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addStatement("super(new $T($L).$L)", builderClass, "supportedEncodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addStatement("super(new $T($L).$L)", builderClass, "strategyFactory", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(state.serviceClass, "service", Modifier.FINAL).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addParameter(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addStatement("super(new $T($L, $L).$L)", builderClass, "strategyFactory", "supportedEncodings", Generator.serviceFactoryBuilderInitChain(state.serviceProto, false)).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(state.blockingServiceClass, "service", Modifier.FINAL).addStatement("super(new $T().$L)", builderClass, Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(state.blockingServiceClass, "service", Modifier.FINAL).addParameter(Types.GrpcRouteExecutionStrategyFactory, "strategyFactory", Modifier.FINAL).addStatement("super(new $T($L).$L)", builderClass, "strategyFactory", Generator.serviceFactoryBuilderInitChain(state.serviceProto, true)).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(builderClass, "builder", Modifier.FINAL).addStatement("super($L)", "builder").build()).addMethod(MethodSpec.methodBuilder("appendServiceFilter").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(serviceFactoryClass).addParameter(state.serviceFilterFactoryClass, "factory", Modifier.FINAL).addStatement("super.$L($L)", "appendServiceFilter", "factory").addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder("appendServiceFilterFactory").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.serviceFilterFactoryClass).addParameter(state.serviceFilterFactoryClass, "existing", Modifier.FINAL).addParameter(state.serviceFilterFactoryClass, "append", Modifier.FINAL).addStatement("return $L -> $L.create($L.create($L))", "service", "existing", "append", "service").build()).addType(serviceBuilderType);
        serviceClassBuilder.addType(serviceFactoryClassSpecBuilder.build());
    }

    private void addClientMetadata(State state, TypeSpec.Builder serviceClassBuilder) {
        state.clientMetaDatas = new ArrayList<ClientMetaData>(state.serviceProto.getMethodCount());
        state.serviceRpcInterfaces.stream().filter(rpcInterface -> !rpcInterface.blocking).forEach(rpcInterface -> {
            DescriptorProtos.MethodDescriptorProto methodProto = rpcInterface.methodProto;
            String name = this.context.deconflictJavaTypeName(StringUtils.sanitizeIdentifier(methodProto.getName(), false) + "Metadata");
            ClassName metaDataClassName = ClassName.bestGuess(name);
            TypeSpec classSpec = TypeSpec.classBuilder(name).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).superclass(Types.DefaultGrpcClientMetadata).addField(FieldSpec.builder(metaDataClassName, "INSTANCE", Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("new $T()", metaDataClassName).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addStatement("super($T.$L)", rpcInterface.className, "PATH").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcMessageEncoding, "encoding", Modifier.FINAL).addStatement("super($T.$L, $L)", rpcInterface.className, "PATH", "encoding").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcExecutionStrategy, "strategy", Modifier.FINAL).addStatement("super($T.$L, $L)", rpcInterface.className, "PATH", "strategy").build()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Types.GrpcExecutionStrategy, "strategy", Modifier.FINAL).addParameter(Types.GrpcMessageEncoding, "encoding", Modifier.FINAL).addStatement("super($T.$L, $L, $L)", rpcInterface.className, "PATH", "strategy", "encoding").build()).build();
            state.clientMetaDatas.add(new ClientMetaData(methodProto, metaDataClassName));
            serviceClassBuilder.addType(classSpec);
        });
    }

    private void addClientInterfaces(State state, TypeSpec.Builder serviceClassBuilder) {
        state.clientClass = ClassName.bestGuess(StringUtils.sanitizeIdentifier(state.serviceProto.getName(), false) + "Client");
        state.filterableClientClass = state.clientClass.peerClass("Filterable" + state.clientClass.simpleName());
        state.blockingClientClass = state.clientClass.peerClass("Blocking" + state.clientClass.simpleName());
        TypeSpec.Builder clientSpecBuilder = TypeSpec.interfaceBuilder(state.clientClass).addModifiers(Modifier.PUBLIC).addSuperinterface(state.filterableClientClass).addSuperinterface(ParameterizedTypeName.get(Types.GrpcClient, state.blockingClientClass));
        TypeSpec.Builder filterableClientSpecBuilder = TypeSpec.interfaceBuilder(state.filterableClientClass).addModifiers(Modifier.PUBLIC).addSuperinterface(Types.FilterableGrpcClient);
        TypeSpec.Builder blockingClientSpecBuilder = TypeSpec.interfaceBuilder(state.blockingClientClass).addModifiers(Modifier.PUBLIC).addSuperinterface(ParameterizedTypeName.get(Types.BlockingGrpcClient, state.clientClass));
        state.clientMetaDatas.forEach(clientMetaData -> {
            clientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), (__, b) -> b.addModifiers(Modifier.ABSTRACT)));
            filterableClientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), (__, b) -> b.addModifiers(Modifier.ABSTRACT).addParameter(clientMetaData.className, "metadata", new Modifier[0])));
            blockingClientSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), (__, b) -> b.addModifiers(Modifier.ABSTRACT))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), (__, b) -> b.addModifiers(Modifier.ABSTRACT).addParameter(clientMetaData.className, "metadata", new Modifier[0])));
        });
        serviceClassBuilder.addType(clientSpecBuilder.build()).addType(filterableClientSpecBuilder.build()).addType(blockingClientSpecBuilder.build());
    }

    private void addClientFilter(State state, TypeSpec.Builder serviceClassBuilder) {
        state.clientFilterClass = state.clientClass.peerClass(state.clientClass.simpleName() + "Filter");
        TypeSpec.Builder classSpecBuilder = Generator.newFilterDelegateCommonMethods(state.clientFilterClass, state.filterableClientClass).addMethod(Generator.newDelegatingCompletableMethodSpec("onClose", "delegate")).addMethod(Generator.newDelegatingMethodSpec("executionContext", "delegate", Types.GrpcExecutionContext, null));
        state.clientMetaDatas.forEach(clientMetaData -> classSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.INTERFACE, NewRpcMethodFlag.CLIENT), (n, b) -> b.addAnnotation(Override.class).addParameter(clientMetaData.className, "metadata", new Modifier[0]).addStatement("return $L.$L($L, $L)", "delegate", n, "metadata", "request"))));
        serviceClassBuilder.addType(classSpecBuilder.build());
    }

    private void addClientFilterFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        state.clientFilterFactoryClass = state.clientFilterClass.peerClass(state.clientFilterClass.simpleName() + "Factory");
        serviceClassBuilder.addType(TypeSpec.interfaceBuilder(state.clientFilterFactoryClass).addModifiers(Modifier.PUBLIC).addSuperinterface(ParameterizedTypeName.get(Types.GrpcClientFilterFactory, state.clientFilterClass, state.filterableClientClass)).build());
    }

    private void addClientFactory(State state, TypeSpec.Builder serviceClassBuilder) {
        ClassName clientFactoryClass = state.clientClass.peerClass("ClientFactory");
        ClassName defaultClientClass = clientFactoryClass.peerClass("Default" + state.clientClass.simpleName());
        ClassName filterableClientToClientClass = clientFactoryClass.peerClass(state.filterableClientClass.simpleName() + "To" + state.clientClass.simpleName());
        ClassName defaultBlockingClientClass = clientFactoryClass.peerClass("Default" + state.blockingClientClass.simpleName());
        ClassName clientToBlockingClientClass = clientFactoryClass.peerClass(state.clientClass.simpleName() + "To" + state.blockingClientClass.simpleName());
        TypeSpec.Builder clientFactorySpecBuilder = TypeSpec.classBuilder(clientFactoryClass).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).superclass(ParameterizedTypeName.get(Types.GrpcClientFactory, state.clientClass, state.blockingClientClass, state.clientFilterClass, state.filterableClientClass, state.clientFilterFactoryClass)).addMethod(MethodSpec.methodBuilder("appendClientFilterFactory").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.clientFilterFactoryClass).addParameter(state.clientFilterFactoryClass, "existing", Modifier.FINAL).addParameter(state.clientFilterFactoryClass, "append", Modifier.FINAL).addStatement("return $L -> $L.create($L.create($L))", "client", "existing", "append", "client").build()).addMethod(MethodSpec.methodBuilder("newClient").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.clientClass).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addStatement("return new $T($L, $L())", defaultClientClass, "factory", "supportedEncodings").build()).addMethod(MethodSpec.methodBuilder("newFilter").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.clientFilterClass).addParameter(state.clientClass, "client", Modifier.FINAL).addParameter(state.clientFilterFactoryClass, "factory", Modifier.FINAL).addStatement("return $L.create($L)", "factory", "client").build()).addMethod(MethodSpec.methodBuilder("newClient").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.clientClass).addParameter(state.filterableClientClass, "client", Modifier.FINAL).addStatement("return new $T($L)", filterableClientToClientClass, "client").build()).addMethod(MethodSpec.methodBuilder("newBlockingClient").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(state.blockingClientClass).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addStatement("return new $T($L, $L())", defaultBlockingClientClass, "factory", "supportedEncodings").build()).addType(this.newDefaultClientClassSpec(state, defaultClientClass, defaultBlockingClientClass)).addType(this.newFilterableClientToClientClassSpec(state, filterableClientToClientClass, clientToBlockingClientClass)).addType(this.newDefaultBlockingClientClassSpec(state, defaultClientClass, defaultBlockingClientClass)).addType(this.newClientToBlockingClientClassSpec(state, clientToBlockingClientClass));
        serviceClassBuilder.addType(clientFactorySpecBuilder.build());
    }

    private TypeSpec newServiceFromRoutesClassSpec(ClassName serviceFromRoutesClass, List<RpcInterface> rpcInterfaces, ClassName serviceClass) {
        TypeSpec.Builder serviceFromRoutesSpecBuilder = TypeSpec.classBuilder(serviceFromRoutesClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(serviceClass).addField(Types.AsyncCloseable, "closeable", Modifier.PRIVATE, Modifier.FINAL);
        MethodSpec.Builder serviceFromRoutesConstructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(Types.AllGrpcRoutes, "routes", Modifier.FINAL).addStatement("$L = $L", "closeable", "routes");
        rpcInterfaces.stream().filter(rpcInterface -> !rpcInterface.blocking).forEach(rpc -> {
            DescriptorProtos.MethodDescriptorProto methodProto = rpc.methodProto;
            ClassName inClass = this.messageTypesMap.get(methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(methodProto.getOutputType());
            String routeName = Generator.routeName(methodProto);
            serviceFromRoutesSpecBuilder.addField(ParameterizedTypeName.get(Generator.routeInterfaceClass(methodProto), inClass, outClass), routeName, Modifier.PRIVATE, Modifier.FINAL);
            serviceFromRoutesConstructorBuilder.addStatement("$L = $L.$L($T.$L)", routeName, "routes", Generator.routeFactoryMethodName(methodProto), rpc.className, "PATH");
            serviceFromRoutesSpecBuilder.addMethod(this.newRpcMethodSpec(methodProto, EnumSet.noneOf(NewRpcMethodFlag.class), (name, builder) -> builder.addAnnotation(Override.class).addParameter(Types.GrpcServiceContext, "ctx", Modifier.FINAL).addStatement("return $L.handle($L, $L)", routeName, "ctx", "request")));
        });
        serviceFromRoutesSpecBuilder.addMethod(serviceFromRoutesConstructorBuilder.build()).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "closeable")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "closeable"));
        return serviceFromRoutesSpecBuilder.build();
    }

    private MethodSpec newRpcMethodSpec(DescriptorProtos.MethodDescriptorProto methodProto, EnumSet<NewRpcMethodFlag> flags, BiFunction<String, MethodSpec.Builder, MethodSpec.Builder> methodBuilderCustomizer) {
        Modifier[] modifierArray;
        ClassName inClass = this.messageTypesMap.get(methodProto.getInputType());
        ClassName outClass = this.messageTypesMap.get(methodProto.getOutputType());
        String name = Generator.routeName(methodProto);
        MethodSpec.Builder methodSpecBuilder = methodBuilderCustomizer.apply(name, MethodSpec.methodBuilder(name)).addModifiers(Modifier.PUBLIC);
        if (flags.contains((Object)NewRpcMethodFlag.INTERFACE)) {
            modifierArray = new Modifier[]{};
        } else {
            Modifier[] modifierArray2 = new Modifier[1];
            modifierArray = modifierArray2;
            modifierArray2[0] = Modifier.FINAL;
        }
        Modifier[] mods = modifierArray;
        if (flags.contains((Object)NewRpcMethodFlag.BLOCKING)) {
            methodSpecBuilder.addException((Type)((Object)Exception.class));
            if (methodProto.getClientStreaming()) {
                if (flags.contains((Object)NewRpcMethodFlag.CLIENT)) {
                    methodSpecBuilder.addParameter(ParameterizedTypeName.get(ClassName.get(Iterable.class), inClass), "request", mods);
                } else {
                    methodSpecBuilder.addParameter(ParameterizedTypeName.get(Types.BlockingIterable, inClass), "request", mods);
                }
            } else {
                methodSpecBuilder.addParameter(inClass, "request", mods);
            }
            if (methodProto.getServerStreaming()) {
                if (flags.contains((Object)NewRpcMethodFlag.CLIENT)) {
                    methodSpecBuilder.returns(ParameterizedTypeName.get(Types.BlockingIterable, outClass));
                } else {
                    methodSpecBuilder.addParameter(ParameterizedTypeName.get(Types.GrpcPayloadWriter, outClass), "responseWriter", mods);
                }
            } else {
                methodSpecBuilder.returns(outClass);
            }
        } else {
            if (methodProto.getClientStreaming()) {
                methodSpecBuilder.addParameter(ParameterizedTypeName.get(Types.Publisher, inClass), "request", mods);
            } else {
                methodSpecBuilder.addParameter(inClass, "request", mods);
            }
            if (methodProto.getServerStreaming()) {
                methodSpecBuilder.returns(ParameterizedTypeName.get(Types.Publisher, outClass));
            } else {
                methodSpecBuilder.returns(ParameterizedTypeName.get(Types.Single, outClass));
            }
        }
        return methodSpecBuilder.build();
    }

    private TypeSpec newDefaultBlockingClientClassSpec(State state, ClassName defaultClientClass, ClassName defaultBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder(defaultBlockingClientClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(state.blockingClientClass).addField(Types.GrpcClientCallFactory, "factory", Modifier.PRIVATE, Modifier.FINAL).addField(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.methodBuilder("asClient").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(state.clientClass).addStatement("return new $T($L, $L)", defaultClientClass, "factory", "supportedEncodings").build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "factory", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("close", "closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("closeGracefully", "closeAsyncGracefully", "factory"));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addParameter(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addStatement("this.$N = $N", "factory", "factory").addStatement("this.$N = $N", "supportedEncodings", "supportedEncodings");
        this.addClientFieldsAndMethods(state, typeSpecBuilder, constructorBuilder, true);
        typeSpecBuilder.addMethod(constructorBuilder.build());
        return typeSpecBuilder.build();
    }

    private TypeSpec newDefaultClientClassSpec(State state, ClassName defaultClientClass, ClassName defaultBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder(defaultClientClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(state.clientClass).addField(Types.GrpcClientCallFactory, "factory", Modifier.PRIVATE, Modifier.FINAL).addField(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.methodBuilder("asBlockingClient").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(state.blockingClientClass).addStatement("return new $T($L, $L)", defaultBlockingClientClass, "factory", "supportedEncodings").build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "factory", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableMethodSpec("onClose", "factory")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("close", "closeAsync", "factory")).addMethod(Generator.newDelegatingCompletableToBlockingMethodSpec("closeGracefully", "closeAsyncGracefully", "factory"));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(Types.GrpcClientCallFactory, "factory", Modifier.FINAL).addParameter(Types.GrpcSupportedEncodings, "supportedEncodings", Modifier.FINAL).addStatement("this.$N = $N", "factory", "factory").addStatement("this.$N = $N", "supportedEncodings", "supportedEncodings");
        this.addClientFieldsAndMethods(state, typeSpecBuilder, constructorBuilder, false);
        typeSpecBuilder.addMethod(constructorBuilder.build());
        return typeSpecBuilder.build();
    }

    private void addClientFieldsAndMethods(State state, TypeSpec.Builder typeSpecBuilder, MethodSpec.Builder constructorBuilder, boolean blocking) {
        EnumSet<NewRpcMethodFlag> rpcMethodSpecsFlags = blocking ? EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT) : EnumSet.of(NewRpcMethodFlag.CLIENT);
        state.clientMetaDatas.forEach(clientMetaData -> {
            ClassName inClass = this.messageTypesMap.get(clientMetaData.methodProto.getInputType());
            ClassName outClass = this.messageTypesMap.get(clientMetaData.methodProto.getOutputType());
            String routeName = Generator.routeName(clientMetaData.methodProto);
            String callFieldName = routeName + "Call";
            typeSpecBuilder.addField(ParameterizedTypeName.get(Generator.clientCallClass(clientMetaData.methodProto, blocking), inClass, outClass), callFieldName, Modifier.PRIVATE, Modifier.FINAL).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, rpcMethodSpecsFlags, (n, b) -> b.addAnnotation(Override.class).addStatement("return $L($T.$L, $L)", n, clientMetaData.className, "INSTANCE", "request"))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, rpcMethodSpecsFlags, (__, b) -> b.addAnnotation(Override.class).addParameter(clientMetaData.className, "metadata", Modifier.FINAL).addStatement("return $L.$L($L, $L)", callFieldName, "request", "metadata", "request")));
            constructorBuilder.addStatement("$L = $N.$L($L($L), $T.class, $T.class)", callFieldName, "factory", Generator.newCallMethodName(clientMetaData.methodProto, blocking), "initSerializationProvider", "supportedEncodings", inClass, outClass);
        });
    }

    private TypeSpec newFilterableClientToClientClassSpec(State state, ClassName filterableClientToClientClass, ClassName clientToBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder(filterableClientToClientClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(state.clientClass).addField(state.filterableClientClass, "client", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(state.filterableClientClass, "client", Modifier.FINAL).addStatement("this.$L = $L", "client", "client").build()).addMethod(MethodSpec.methodBuilder("asBlockingClient").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(state.blockingClientClass).addStatement("return new $T(this)", clientToBlockingClientClass).build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "client", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingCompletableMethodSpec("onClose", "client")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "client")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "client"));
        state.clientMetaDatas.forEach(clientMetaData -> typeSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.CLIENT), (n, b) -> b.addAnnotation(Override.class).addStatement("return $L($T.$L, $L)", n, clientMetaData.className, "INSTANCE", "request"))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.CLIENT), (n, b) -> b.addAnnotation(Override.class).addParameter(clientMetaData.className, "metadata", Modifier.FINAL).addStatement("return $L.$L($L, $L)", "client", n, "metadata", "request"))));
        return typeSpecBuilder.build();
    }

    private TypeSpec newClientToBlockingClientClassSpec(State state, ClassName clientToBlockingClientClass) {
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder(clientToBlockingClientClass).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(state.blockingClientClass).addField(state.clientClass, "client", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(state.clientClass, "client", Modifier.FINAL).addStatement("this.$L = $L", "client", "client").build()).addMethod(MethodSpec.methodBuilder("asClient").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(state.clientClass).addStatement("return $L", "client").build()).addMethod(Generator.newDelegatingMethodSpec("executionContext", "client", Types.GrpcExecutionContext, null)).addMethod(Generator.newDelegatingMethodSpec("close", "client", null, ClassName.get(Exception.class)));
        state.clientMetaDatas.forEach(clientMetaData -> {
            CodeBlock requestExpression = clientMetaData.methodProto.getClientStreaming() ? CodeBlock.of("$T.fromIterable($L)", Types.Publisher, "request") : CodeBlock.of("request", new Object[0]);
            String responseConversionExpression = clientMetaData.methodProto.getServerStreaming() ? ".toIterable()" : ".toFuture().get()";
            typeSpecBuilder.addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT), (n, b) -> b.addAnnotation(Override.class).addStatement("return $L.$L($L)$L", "client", n, requestExpression, responseConversionExpression))).addMethod(this.newRpcMethodSpec(clientMetaData.methodProto, EnumSet.of(NewRpcMethodFlag.BLOCKING, NewRpcMethodFlag.CLIENT), (n, b) -> b.addAnnotation(Override.class).addParameter(clientMetaData.className, "metadata", Modifier.FINAL).addStatement("return $L.$L($L, $L)$L", "client", n, "metadata", requestExpression, responseConversionExpression)));
        });
        return typeSpecBuilder.build();
    }

    private TypeSpec newServiceInterfaceSpec(State state, boolean blocking) {
        String name = this.context.deconflictJavaTypeName((blocking ? "Blocking" : "") + StringUtils.sanitizeIdentifier(state.serviceProto.getName(), false) + "Service");
        TypeSpec.Builder interfaceSpecBuilder = TypeSpec.interfaceBuilder(name).addModifiers(Modifier.PUBLIC).addSuperinterface(blocking ? Types.BlockingGrpcService : Types.GrpcService);
        state.serviceRpcInterfaces.stream().filter(e -> e.blocking == blocking).map(e -> e.className).forEach(interfaceSpecBuilder::addSuperinterface);
        return interfaceSpecBuilder.build();
    }

    private static TypeSpec.Builder newFilterDelegateCommonMethods(ClassName filterClass, ClassName filteredClass) {
        return TypeSpec.classBuilder(filterClass).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addSuperinterface(filteredClass).addField(filteredClass, "delegate", Modifier.PRIVATE, Modifier.FINAL).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PROTECTED).addParameter(filteredClass, "delegate", Modifier.FINAL).addStatement("this.$L = $L", "delegate", "delegate").build()).addMethod(MethodSpec.methodBuilder("delegate").addModifiers(Modifier.PROTECTED).returns(filteredClass).addStatement("return $L", "delegate").build()).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsync", "delegate")).addMethod(Generator.newDelegatingCompletableMethodSpec("closeAsyncGracefully", "delegate"));
    }

    private static String routeName(DescriptorProtos.MethodDescriptorProto methodProto) {
        return StringUtils.sanitizeIdentifier(methodProto.getName(), true);
    }

    private static ClassName routeInterfaceClass(DescriptorProtos.MethodDescriptorProto methodProto) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.StreamingRoute : Types.RequestStreamingRoute) : (methodProto.getServerStreaming() ? Types.ResponseStreamingRoute : Types.Route);
    }

    private static ClassName routeInterfaceClass(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? (blocking ? Types.BlockingStreamingRoute : Types.StreamingRoute) : (blocking ? Types.BlockingRequestStreamingRoute : Types.RequestStreamingRoute)) : (methodProto.getServerStreaming() ? (blocking ? Types.BlockingResponseStreamingRoute : Types.ResponseStreamingRoute) : (blocking ? Types.BlockingRoute : Types.Route));
    }

    private static String routeFactoryMethodName(DescriptorProtos.MethodDescriptorProto methodProto) {
        return (methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? "streamingR" : "requestStreamingR") : (methodProto.getServerStreaming() ? "responseStreamingR" : "r")) + "outeFor";
    }

    private static String addRouteMethodName(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return "add" + (blocking ? "Blocking" : "") + Generator.streamingNameModifier(methodProto) + "Route";
    }

    private static String serviceFactoryBuilderInitChain(DescriptorProtos.ServiceDescriptorProto serviceProto, boolean blocking) {
        return serviceProto.getMethodList().stream().map(methodProto -> Generator.routeName(methodProto) + (blocking ? "Blocking" : "") + '(' + "service" + ')').collect(Collectors.joining("."));
    }

    private static ClassName clientCallClass(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        if (!blocking) {
            return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.StreamingClientCall : Types.RequestStreamingClientCall) : (methodProto.getServerStreaming() ? Types.ResponseStreamingClientCall : Types.ClientCall);
        }
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? Types.BlockingStreamingClientCall : Types.BlockingRequestStreamingClientCall) : (methodProto.getServerStreaming() ? Types.BlockingResponseStreamingClientCall : Types.BlockingClientCall);
    }

    private static String newCallMethodName(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking) {
        return "new" + (blocking ? "Blocking" : "") + Generator.streamingNameModifier(methodProto) + "Call";
    }

    private static String streamingNameModifier(DescriptorProtos.MethodDescriptorProto methodProto) {
        return methodProto.getClientStreaming() ? (methodProto.getServerStreaming() ? "Streaming" : "RequestStreaming") : (methodProto.getServerStreaming() ? "ResponseStreaming" : "");
    }

    private static MethodSpec newDelegatingCompletableMethodSpec(String methodName, String fieldName) {
        return Generator.newDelegatingMethodSpec(methodName, fieldName, Types.Completable, null);
    }

    private static MethodSpec newDelegatingMethodSpec(String methodName, String fieldName, @Nullable ClassName returnClass, @Nullable ClassName thrownClass) {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("$L$L.$L()", returnClass != null ? "return " : "", fieldName, methodName);
        if (returnClass != null) {
            methodSpecBuilder.returns(returnClass);
        }
        if (thrownClass != null) {
            methodSpecBuilder.addException(thrownClass);
        }
        return methodSpecBuilder.build();
    }

    private static MethodSpec newDelegatingCompletableToBlockingMethodSpec(String blockingMethodName, String completableMethodName, String fieldName) {
        return MethodSpec.methodBuilder(blockingMethodName).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addException((Type)((Object)Exception.class)).addStatement("$L.$L().toFuture().get()", fieldName, completableMethodName).build();
    }

    static enum NewRpcMethodFlag {
        BLOCKING,
        INTERFACE,
        CLIENT;

    }

    private static final class State {
        final DescriptorProtos.ServiceDescriptorProto serviceProto;
        List<RpcInterface> serviceRpcInterfaces;
        ClassName serviceClass;
        ClassName blockingServiceClass;
        ClassName serviceFilterClass;
        ClassName serviceFilterFactoryClass;
        List<ClientMetaData> clientMetaDatas;
        ClassName clientClass;
        ClassName filterableClientClass;
        ClassName blockingClientClass;
        ClassName clientFilterClass;
        ClassName clientFilterFactoryClass;

        private State(DescriptorProtos.ServiceDescriptorProto serviceProto) {
            this.serviceProto = serviceProto;
        }
    }

    private static final class ClientMetaData {
        final DescriptorProtos.MethodDescriptorProto methodProto;
        final ClassName className;

        private ClientMetaData(DescriptorProtos.MethodDescriptorProto methodProto, ClassName className) {
            this.methodProto = methodProto;
            this.className = className;
        }
    }

    private static final class RpcInterface {
        final DescriptorProtos.MethodDescriptorProto methodProto;
        final boolean blocking;
        final ClassName className;

        private RpcInterface(DescriptorProtos.MethodDescriptorProto methodProto, boolean blocking, ClassName className) {
            this.methodProto = methodProto;
            this.blocking = blocking;
            this.className = className;
        }
    }
}

