/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import javax.annotation.Nullable;

final class StringUtils {
    private StringUtils() {
    }

    static String sanitizeIdentifier(String v, boolean firstToLower) {
        if (StringUtils.isNullOrEmpty(v)) {
            throw new IllegalArgumentException("java identifier must have length >= 1");
        }
        StringBuilder sb = new StringBuilder(v.length());
        sb.append(firstToLower ? Character.toLowerCase(v.charAt(0)) : Character.toUpperCase(v.charAt(0)));
        boolean afterUnderscore = false;
        for (int i = 1; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '_') {
                afterUnderscore = true;
                continue;
            }
            sb.append(afterUnderscore ? Character.toUpperCase(c) : c);
            afterUnderscore = false;
        }
        return sb.toString();
    }

    static boolean isNotNullNorEmpty(@Nullable String v) {
        return v != null && !v.isEmpty();
    }

    static boolean isNullOrEmpty(@Nullable String v) {
        return v == null || v.isEmpty();
    }
}

