/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.DelegatingConnectionFactory;
import io.servicetalk.client.api.RequestTracker;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.netty.GrpcLifecycleObserverRequesterFilter;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.TransportObserver;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GrpcRequestTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcRequestTracker.class);
    private static final Function<GrpcStatus, RequestTracker.ErrorClass> PEER_RESPONSE_ERROR_CLASSIFIER = status -> {
        switch (status.code()) {
            case OK: {
                return null;
            }
            case CANCELLED: {
                return RequestTracker.ErrorClass.CANCELLED;
            }
        }
        return RequestTracker.ErrorClass.EXT_ORIGIN_REQUEST_FAILED;
    };
    private static final Function<Throwable, RequestTracker.ErrorClass> ERROR_CLASS_FUNCTION = exn -> RequestTracker.ErrorClass.EXT_ORIGIN_REQUEST_FAILED;

    private GrpcRequestTracker() {
    }

    static <ResolvedAddress> ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> filter() {
        return new ConnectionFactoryFilterImpl();
    }

    private static class Observer
    implements GrpcLifecycleObserver {
        private final RequestTracker tracker;

        Observer(RequestTracker tracker) {
            this.tracker = tracker;
        }

        public GrpcLifecycleObserver.GrpcExchangeObserver onNewExchange() {
            return new RequestTrackerExchangeObserver(this.tracker);
        }

        private static final class RequestTrackerExchangeObserver
        implements GrpcLifecycleObserver.GrpcExchangeObserver,
        GrpcLifecycleObserver.GrpcResponseObserver {
            private static final AtomicLongFieldUpdater<RequestTrackerExchangeObserver> START_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(RequestTrackerExchangeObserver.class, "startTime");
            private final RequestTracker tracker;
            private volatile long startTime = Long.MIN_VALUE;

            RequestTrackerExchangeObserver(RequestTracker tracker) {
                this.tracker = tracker;
            }

            public GrpcLifecycleObserver.GrpcRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
                START_TIME_UPDATER.set(this, this.tracker.beforeRequestStart());
                return super.onRequest(requestMetaData);
            }

            public GrpcLifecycleObserver.GrpcResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
                return this;
            }

            public void onResponseError(Throwable cause) {
                long startTime = this.finish();
                if (this.checkOnce(startTime)) {
                    this.tracker.onRequestError(startTime, (RequestTracker.ErrorClass)ERROR_CLASS_FUNCTION.apply(cause));
                }
            }

            public void onResponseCancel() {
                long startTime = this.finish();
                if (this.checkOnce(startTime)) {
                    this.tracker.onRequestError(startTime, RequestTracker.ErrorClass.CANCELLED);
                }
            }

            public void onGrpcStatus(GrpcStatus status) {
                long startTime;
                RequestTracker.ErrorClass error = (RequestTracker.ErrorClass)PEER_RESPONSE_ERROR_CLASSIFIER.apply(status);
                if (error != null && this.checkOnce(startTime = this.finish())) {
                    this.tracker.onRequestError(startTime, error);
                }
            }

            public void onResponseComplete() {
                long startTime = this.finish();
                if (this.checkOnce(startTime)) {
                    this.tracker.onRequestSuccess(startTime);
                }
            }

            private long finish() {
                return START_TIME_UPDATER.getAndSet(this, Long.MAX_VALUE);
            }

            private boolean checkOnce(long startTime) {
                return startTime != Long.MAX_VALUE && startTime != Long.MIN_VALUE;
            }
        }
    }

    private static class ConnectionFactoryWrapper<ResolvedAddress>
    extends DelegatingConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> {
        ConnectionFactoryWrapper(ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> delegate) {
            super(delegate);
        }

        public Single<FilterableStreamingHttpConnection> newConnection(ResolvedAddress resolvedAddress, @Nullable ContextMap context, @Nullable TransportObserver observer) {
            Single result = this.delegate().newConnection(resolvedAddress, context, observer);
            if (context == null) {
                LOGGER.debug("Context is null. In order for {} to get access to the {}, health-monitor of this connection, the context must not be null.", (Object)GrpcRequestTracker.class.getSimpleName(), (Object)RequestTracker.class.getSimpleName());
            } else {
                result = result.map(connection -> this.transformConnection((FilterableStreamingHttpConnection)connection, context));
            }
            return result;
        }

        private FilterableStreamingHttpConnection transformConnection(FilterableStreamingHttpConnection connection, ContextMap context) {
            RequestTracker requestTracker = (RequestTracker)context.remove(RequestTracker.REQUEST_TRACKER_KEY);
            if (requestTracker == null) {
                LOGGER.debug("{} is not set in context. In order for {} to get access to the {}, health-monitor of this connection, the context must be properly wired.", new Object[]{RequestTracker.REQUEST_TRACKER_KEY.name(), GrpcRequestTracker.class.getSimpleName(), RequestTracker.class.getSimpleName()});
                return connection;
            }
            LOGGER.debug("Added request tracker to connection {}.", (Object)connection.connectionContext());
            GrpcLifecycleObserverRequesterFilter filter = new GrpcLifecycleObserverRequesterFilter(new Observer(requestTracker));
            return filter.create(connection);
        }
    }

    private static final class ConnectionFactoryFilterImpl<ResolvedAddress>
    implements ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> {
        private ConnectionFactoryFilterImpl() {
        }

        public ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> create(ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> original) {
            return new ConnectionFactoryWrapper<ResolvedAddress>(original);
        }

        public ExecutionStrategy requiredOffloads() {
            return ExecutionStrategy.offloadNone();
        }
    }
}

