/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.internal.GrpcContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;

final class GrpcEnforceTrailersOnlyResponseServiceFilter
implements StreamingHttpServiceFilterFactory {
    static final GrpcEnforceTrailersOnlyResponseServiceFilter INSTANCE = new GrpcEnforceTrailersOnlyResponseServiceFilter();

    private GrpcEnforceTrailersOnlyResponseServiceFilter() {
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                return this.delegate().handle(ctx, request, responseFactory).flatMap(response -> {
                    Single mappedResponse = Boolean.TRUE.equals(response.context().get(GrpcContextKeys.TRAILERS_ONLY_RESPONSE)) ? response.toResponse().map(HttpResponse::toStreamingResponse) : Single.succeeded((Object)response);
                    return mappedResponse.shareContextOnSubscribe();
                });
            }
        };
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }
}

