/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.BlockingGrpcClient;
import io.servicetalk.grpc.api.GrpcClient;
import io.servicetalk.grpc.api.GrpcClientBuilder;
import io.servicetalk.grpc.api.GrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientFactory;
import io.servicetalk.grpc.api.GrpcFilters;
import io.servicetalk.grpc.api.GrpcStatusException;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.grpc.netty.GrpcRequestTracker;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class DefaultGrpcClientBuilder<U, R>
implements GrpcClientBuilder<U, R> {
    @Nullable
    private Duration defaultTimeout;
    private boolean appendTimeoutFilter = true;
    private GrpcClientBuilder.HttpInitializer<U, R> httpInitializer = builder -> {};
    private final Supplier<SingleAddressHttpClientBuilder<U, R>> httpClientBuilderSupplier;

    DefaultGrpcClientBuilder(Supplier<SingleAddressHttpClientBuilder<U, R>> httpClientBuilderSupplier) {
        this.httpClientBuilderSupplier = httpClientBuilderSupplier;
    }

    public GrpcClientBuilder<U, R> initializeHttp(GrpcClientBuilder.HttpInitializer<U, R> initializer) {
        this.httpInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    public GrpcClientBuilder<U, R> defaultTimeout(Duration defaultTimeout) {
        this.defaultTimeout = DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        return this;
    }

    public GrpcClientBuilder<U, R> defaultTimeout(@Nullable Duration defaultTimeout, boolean appendTimeoutFilter) {
        this.defaultTimeout = defaultTimeout == null ? null : DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        this.appendTimeoutFilter = appendTimeoutFilter;
        return this;
    }

    public <Client extends GrpcClient<?>> Client build(GrpcClientFactory<Client, ?> clientFactory) {
        return (Client)clientFactory.newClientForCallFactory(this.newGrpcClientCallFactory());
    }

    public <BlockingClient extends BlockingGrpcClient<?>> BlockingClient buildBlocking(GrpcClientFactory<?, BlockingClient> clientFactory) {
        return (BlockingClient)clientFactory.newBlockingClientForCallFactory(this.newGrpcClientCallFactory());
    }

    public GrpcClientBuilder.MultiClientBuilder buildMulti() {
        final GrpcClientCallFactory callFactory = this.newGrpcClientCallFactory();
        return new GrpcClientBuilder.MultiClientBuilder(){

            public <Client extends GrpcClient<?>> Client build(GrpcClientFactory<Client, ?> clientFactory) {
                return (Client)clientFactory.newClientForCallFactory(callFactory);
            }

            public <BlockingClient extends BlockingGrpcClient<?>> BlockingClient buildBlocking(GrpcClientFactory<?, BlockingClient> clientFactory) {
                return (BlockingClient)clientFactory.newBlockingClientForCallFactory(callFactory);
            }
        };
    }

    private GrpcClientCallFactory newGrpcClientCallFactory() {
        SingleAddressHttpClientBuilder builder = this.httpClientBuilderSupplier.get().protocols(new HttpProtocolConfig[]{HttpProtocolConfigs.h2Default()});
        builder.appendClientFilter(CatchAllHttpClientFilter.INSTANCE);
        if (this.appendTimeoutFilter) {
            builder.appendClientFilter(GrpcFilters.newGrpcDeadlineClientFilterFactory());
        }
        builder.appendConnectionFactoryFilter(GrpcRequestTracker.filter());
        this.httpInitializer.initialize(builder);
        Duration timeout = DurationUtils.isInfinite((Duration)this.defaultTimeout, (Duration)DeadlineUtils.GRPC_MAX_TIMEOUT) ? null : this.defaultTimeout;
        return GrpcClientCallFactory.from((StreamingHttpClient)builder.buildStreaming(), (Duration)timeout);
    }

    static final class CatchAllHttpClientFilter
    implements StreamingHttpClientFilterFactory {
        static final StreamingHttpClientFilterFactory INSTANCE = new CatchAllHttpClientFilter();

        private CatchAllHttpClientFilter() {
        }

        public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
            return new StreamingHttpClientFilter(client){

                protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                    return CatchAllHttpClientFilter.request(delegate, request);
                }

                public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
                    return this.delegate().reserveConnection(metaData).map(r -> new ReservedStreamingHttpConnectionFilter((FilterableReservedStreamingHttpConnection)r){

                        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                            return CatchAllHttpClientFilter.request((StreamingHttpRequester)this.delegate(), request);
                        }
                    });
                }
            };
        }

        private static Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
            Single resp;
            try {
                resp = delegate.request(request);
            }
            catch (Throwable t) {
                return Single.failed((Throwable)CatchAllHttpClientFilter.toGrpcException(t));
            }
            return resp.onErrorMap(CatchAllHttpClientFilter::toGrpcException);
        }

        private static GrpcStatusException toGrpcException(Throwable cause) {
            return GrpcStatusException.fromThrowable((Throwable)cause);
        }

        public HttpExecutionStrategy requiredOffloads() {
            return HttpExecutionStrategies.offloadNone();
        }
    }
}

