/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.GrpcExecutionStrategies;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcServerBuilder;
import io.servicetalk.grpc.api.GrpcServerSecurityConfigurator;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.netty.DefaultGrpcServerSecurityConfigurator;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerSecurityConfigurator;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ExecutionContextBuilder;
import java.net.SocketOption;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

final class DefaultGrpcServerBuilder
extends GrpcServerBuilder
implements GrpcServiceFactory.ServerBinder {
    private final HttpServerBuilder httpServerBuilder;
    private final ExecutionContextBuilder contextBuilder = new ExecutionContextBuilder().executionStrategy((ExecutionStrategy)GrpcExecutionStrategies.defaultStrategy());

    DefaultGrpcServerBuilder(HttpServerBuilder httpServerBuilder) {
        this.httpServerBuilder = httpServerBuilder.protocols(new HttpProtocolConfig[]{HttpProtocolConfigs.h2Default()}).allowDropRequestTrailers(true);
    }

    public GrpcServerBuilder protocols(HttpProtocolConfig ... protocols) {
        this.httpServerBuilder.protocols(protocols);
        return this;
    }

    public GrpcServerBuilder backlog(int backlog) {
        this.httpServerBuilder.backlog(backlog);
        return this;
    }

    public GrpcServerSecurityConfigurator secure() {
        HttpServerSecurityConfigurator secure = this.httpServerBuilder.secure();
        return new DefaultGrpcServerSecurityConfigurator(secure, this);
    }

    public GrpcServerSecurityConfigurator secure(String ... sniHostnames) {
        HttpServerSecurityConfigurator secure = this.httpServerBuilder.secure(sniHostnames);
        return new DefaultGrpcServerSecurityConfigurator(secure, this);
    }

    public <T> GrpcServerBuilder socketOption(SocketOption<T> option, T value) {
        this.httpServerBuilder.socketOption(option, value);
        return this;
    }

    public GrpcServerBuilder enableWireLogging(String loggerName) {
        this.httpServerBuilder.enableWireLogging(loggerName);
        return this;
    }

    public GrpcServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.httpServerBuilder.enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    public GrpcServerBuilder transportObserver(TransportObserver transportObserver) {
        this.httpServerBuilder.transportObserver(transportObserver);
        return this;
    }

    public GrpcServerBuilder disableDrainingRequestPayloadBody() {
        this.httpServerBuilder.disableDrainingRequestPayloadBody();
        return this;
    }

    public GrpcServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        this.httpServerBuilder.appendConnectionAcceptorFilter(factory);
        return this;
    }

    public GrpcServerBuilder ioExecutor(IoExecutor ioExecutor) {
        this.contextBuilder.ioExecutor(ioExecutor);
        this.httpServerBuilder.ioExecutor(ioExecutor);
        return this;
    }

    public GrpcServerBuilder bufferAllocator(BufferAllocator allocator) {
        this.contextBuilder.bufferAllocator(allocator);
        this.httpServerBuilder.bufferAllocator(allocator);
        return this;
    }

    public GrpcServerBuilder executionStrategy(GrpcExecutionStrategy strategy) {
        this.contextBuilder.executionStrategy((ExecutionStrategy)strategy);
        this.httpServerBuilder.executionStrategy((HttpExecutionStrategy)strategy);
        return this;
    }

    protected Single<ServerContext> doListen(GrpcServiceFactory<?, ?, ?> serviceFactory) {
        return serviceFactory.bind((GrpcServiceFactory.ServerBinder)this, this.contextBuilder.build());
    }

    protected void doAppendHttpServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.httpServerBuilder.appendServiceFilter(factory);
    }

    protected void doAppendHttpServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.httpServerBuilder.appendServiceFilter(predicate, factory);
    }

    public Single<ServerContext> bind(HttpService service) {
        return this.httpServerBuilder.listen(service);
    }

    public Single<ServerContext> bindStreaming(StreamingHttpService service) {
        return this.httpServerBuilder.listenStreaming(service);
    }

    public Single<ServerContext> bindBlocking(BlockingHttpService service) {
        return this.httpServerBuilder.listenBlocking(service);
    }

    public Single<ServerContext> bindBlockingStreaming(BlockingStreamingHttpService service) {
        return this.httpServerBuilder.listenBlockingStreaming(service);
    }
}

