// Generated by ServiceTalk gRPC protoc plugin
package io.servicetalk.health.v1;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.data.protobuf.ProtobufSerializerFactory;
import io.servicetalk.encoding.api.BufferDecoderGroup;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.EmptyBufferDecoderGroup;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.grpc.api.BlockingGrpcClient;
import io.servicetalk.grpc.api.BlockingGrpcService;
import io.servicetalk.grpc.api.BlockingStreamingGrpcServerResponse;
import io.servicetalk.grpc.api.DefaultGrpcClientMetadata;
import io.servicetalk.grpc.api.GrpcBindableService;
import io.servicetalk.grpc.api.GrpcClient;
import io.servicetalk.grpc.api.GrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientFactory;
import io.servicetalk.grpc.api.GrpcClientMetadata;
import io.servicetalk.grpc.api.GrpcExecutionContext;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcPayloadWriter;
import io.servicetalk.grpc.api.GrpcRoutes;
import io.servicetalk.grpc.api.GrpcSerializationProvider;
import io.servicetalk.grpc.api.GrpcService;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.api.MethodDescriptor;
import io.servicetalk.grpc.api.MethodDescriptors;
import io.servicetalk.grpc.protobuf.ProtoBufSerializationProviderBuilder;
import io.servicetalk.router.api.RouteExecutionStrategyFactory;
import java.lang.Deprecated;
import java.lang.Exception;
import java.lang.FunctionalInterface;
import java.lang.Override;
import java.lang.String;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * Class for Health Service
 */
public final class Health {
    private static final MethodDescriptor<HealthCheckRequest, HealthCheckResponse> CheckRpc_MD = MethodDescriptors.newMethodDescriptor("/grpc.health.v1.Health/Check", "check", false, false, HealthCheckRequest.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckRequest.parser()), HealthCheckRequest::getSerializedSize, false, true, HealthCheckResponse.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckResponse.parser()), HealthCheckResponse::getSerializedSize);

    private static final MethodDescriptor<HealthCheckRequest, HealthCheckResponse> BlockingCheckRpc_MD = MethodDescriptors.newMethodDescriptor("/grpc.health.v1.Health/Check", "check", false, false, HealthCheckRequest.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckRequest.parser()), HealthCheckRequest::getSerializedSize, false, false, HealthCheckResponse.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckResponse.parser()), HealthCheckResponse::getSerializedSize);

    private static final MethodDescriptor<HealthCheckRequest, HealthCheckResponse> WatchRpc_MD = MethodDescriptors.newMethodDescriptor("/grpc.health.v1.Health/Watch", "watch", false, false, HealthCheckRequest.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckRequest.parser()), HealthCheckRequest::getSerializedSize, true, true, HealthCheckResponse.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckResponse.parser()), HealthCheckResponse::getSerializedSize);

    private static final MethodDescriptor<HealthCheckRequest, HealthCheckResponse> BlockingWatchRpc_MD = MethodDescriptors.newMethodDescriptor("/grpc.health.v1.Health/Watch", "watch", false, false, HealthCheckRequest.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckRequest.parser()), HealthCheckRequest::getSerializedSize, true, false, HealthCheckResponse.class, "+proto", ProtobufSerializerFactory.PROTOBUF.serializerDeserializer(HealthCheckResponse.parser()), HealthCheckResponse::getSerializedSize);

    private static final Collection<MethodDescriptor<?, ?>> ASYNC_METHOD_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(CheckRpc_MD, WatchRpc_MD));

    private static final Collection<MethodDescriptor<?, ?>> BLOCKING_METHOD_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(BlockingCheckRpc_MD, BlockingWatchRpc_MD));

    private Health() {
        // no instances
    }

    private static GrpcSerializationProvider initSerializationProvider(
            final List<ContentCodec> supportedMessageCodings) {
        ProtoBufSerializationProviderBuilder builder = new ProtoBufSerializationProviderBuilder();
        builder.supportedMessageCodings(supportedMessageCodings);
        builder.registerMessageType(HealthCheckRequest.class, HealthCheckRequest.parser());
        builder.registerMessageType(HealthCheckResponse.class, HealthCheckResponse.parser());
        return builder.build();
    }

    private static boolean isSupportedMessageCodingsEmpty(
            final List<ContentCodec> supportedMessageCodings) {
        return supportedMessageCodings.isEmpty() || (supportedMessageCodings.size() == 1 && Identity.identity().equals(supportedMessageCodings.get(0)));
    }

    @FunctionalInterface
    public interface CheckRpc extends GrpcService {
        /**
         * @deprecated Use {@link #methodDescriptor}.
         */
        @Deprecated
        String PATH = "/grpc.health.v1.Health/Check";

        static MethodDescriptor<HealthCheckRequest, HealthCheckResponse> methodDescriptor() {
            return CheckRpc_MD;
        }

        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @param ctx context associated with this service and request.
         * @param request the request from the client.
         * @return a {@link Single} which sends the response to the client when it terminates.
         */
        Single<HealthCheckResponse> check(GrpcServiceContext ctx, HealthCheckRequest request);
    }

    @FunctionalInterface
    public interface BlockingCheckRpc extends BlockingGrpcService {
        /**
         * @deprecated Use {@link #methodDescriptor}.
         */
        @Deprecated
        String PATH = "/grpc.health.v1.Health/Check";

        static MethodDescriptor<HealthCheckRequest, HealthCheckResponse> methodDescriptor() {
            return BlockingCheckRpc_MD;
        }

        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @param ctx context associated with this service and request.
         * @param request the request from the client.
         * @return the response to send to the client
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        HealthCheckResponse check(GrpcServiceContext ctx, HealthCheckRequest request) throws
                Exception;
    }

    @FunctionalInterface
    public interface WatchRpc extends GrpcService {
        /**
         * @deprecated Use {@link #methodDescriptor}.
         */
        @Deprecated
        String PATH = "/grpc.health.v1.Health/Watch";

        static MethodDescriptor<HealthCheckRequest, HealthCheckResponse> methodDescriptor() {
            return WatchRpc_MD;
        }

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @param ctx context associated with this service and request.
         * @param request the request from the client.
         * @return used to write a stream of type {@link HealthCheckResponse} to the client.
         */
        Publisher<HealthCheckResponse> watch(GrpcServiceContext ctx, HealthCheckRequest request);
    }

    @FunctionalInterface
    public interface BlockingWatchRpc extends BlockingGrpcService {
        /**
         * @deprecated Use {@link #methodDescriptor}.
         */
        @Deprecated
        String PATH = "/grpc.health.v1.Health/Watch";

        static MethodDescriptor<HealthCheckRequest, HealthCheckResponse> methodDescriptor() {
            return BlockingWatchRpc_MD;
        }

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @param ctx context associated with this service and request.
         * @param request the request from the client.
         * @param responseWriter used to write a stream of type {@link HealthCheckResponse} to the client.
         * The implementation of this method is responsible for calling {@link GrpcPayloadWriter#close()}.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         * @deprecated Use {@link #watch(GrpcServiceContext, HealthCheckRequest, BlockingStreamingGrpcServerResponse)}.
         * In the next release, this method will have a default implementation but the new overload won't.
         * To avoid breaking API changes, make sure to implement both methods. The release after next will remove this method.
         * This intermediate step is necessary to maintain {@link FunctionalInterface} contract that requires to have a single non-default method.
         */
        @Deprecated
        void watch(GrpcServiceContext ctx, HealthCheckRequest request,
                GrpcPayloadWriter<HealthCheckResponse> responseWriter) throws Exception;

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @param ctx context associated with this service and request.
         * @param request the request from the client.
         * @param response used to send response meta-data and continue writing a stream of type {@link HealthCheckResponse} to the client.
         * The implementation of this method is responsible for calling {@link GrpcPayloadWriter#close()}.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        default void watch(GrpcServiceContext ctx, HealthCheckRequest request,
                BlockingStreamingGrpcServerResponse<HealthCheckResponse> response) throws
                Exception {
            watch(ctx, request, response.sendMetaData());
        }
    }

    public interface HealthService extends GrpcBindableService<HealthService>, CheckRpc, WatchRpc {
        /**
         * Makes a {@link ServiceFactory} bound to this instance implementing {@link HealthService}
         */
        @Override
        default ServiceFactory bindService() {
            return new ServiceFactory(this);
        }

        @Override
        default Collection<MethodDescriptor<?, ?>> methodDescriptors() {
            return ASYNC_METHOD_DESCRIPTORS;
        }
    }

    public interface BlockingHealthService extends GrpcBindableService<HealthService>, BlockingCheckRpc, BlockingWatchRpc {
        /**
         * Makes a {@link ServiceFactory} bound to this instance implementing {@link BlockingHealthService}
         */
        @Override
        default ServiceFactory bindService() {
            return new ServiceFactory(this);
        }

        @Override
        default Collection<MethodDescriptor<?, ?>> methodDescriptors() {
            return BLOCKING_METHOD_DESCRIPTORS;
        }
    }

    public static final class ServiceFactory extends GrpcServiceFactory<HealthService> {
        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         */
        public ServiceFactory(final HealthService service) {
            this(new Builder().check(service).watch(service));
        }

        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         */
        public ServiceFactory(final BlockingHealthService service) {
            this(new Builder().checkBlocking(service).watchBlocking(service));
        }

        private ServiceFactory(final Builder builder) {
            super(builder);
        }

        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         * @param supportedMessageCodings the set of allowed encodings
         * @deprecated Use {@link Builder#Builder()}, {@link Builder#bufferDecoderGroup(BufferDecoderGroup)}, and {@link Builder#bufferEncoders(List)}.
         */
        @Deprecated
        public ServiceFactory(final HealthService service,
                final List<ContentCodec> supportedMessageCodings) {
            this(new Builder(supportedMessageCodings).check(service).watch(service));
        }

        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         * @param strategyFactory a factory that creates an execution strategy for different {@link io.servicetalk.router.api.RouteExecutionStrategy#id() id}s
         * @deprecated Use {@link Builder#Builder()} and set the custom strategy on {@link Builder#routeExecutionStrategyFactory(RouteExecutionStrategyFactory)} instead.
         */
        @Deprecated
        public ServiceFactory(final HealthService service,
                final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory) {
            this(new Builder(strategyFactory).check(service).watch(service));
        }

        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         * @param strategyFactory a factory that creates an execution strategy for different {@link io.servicetalk.router.api.RouteExecutionStrategy#id() id}s
         * @param supportedMessageCodings the set of allowed encodings
         * @deprecated Use {@link Builder#Builder(RouteExecutionStrategyFactory)}, {@link Builder#bufferDecoderGroup(BufferDecoderGroup)}, and {@link Builder#bufferEncoders(List)}.
         */
        @Deprecated
        public ServiceFactory(final HealthService service,
                final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory,
                final List<ContentCodec> supportedMessageCodings) {
            this(new Builder(strategyFactory, supportedMessageCodings).check(service).watch(service));
        }

        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         * @param supportedMessageCodings the set of allowed encodings
         * @deprecated Use {@link Builder#Builder()}, {@link Builder#bufferDecoderGroup(BufferDecoderGroup)}, and {@link Builder#bufferEncoders(List)}.
         */
        @Deprecated
        public ServiceFactory(final BlockingHealthService service,
                final List<ContentCodec> supportedMessageCodings) {
            this(new Builder(supportedMessageCodings).checkBlocking(service).watchBlocking(service));
        }

        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         * @param strategyFactory a factory that creates an execution strategy for different {@link io.servicetalk.router.api.RouteExecutionStrategy#id() id}s
         * @deprecated Use {@link Builder#Builder()} and set the custom strategy on {@link Builder#routeExecutionStrategyFactory(RouteExecutionStrategyFactory)} instead.
         */
        @Deprecated
        public ServiceFactory(final BlockingHealthService service,
                final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory) {
            this(new Builder(strategyFactory).checkBlocking(service).watchBlocking(service));
        }

        /**
         * Create a new instance.
         *
         * @param service a service to handle incoming requests
         * @param strategyFactory a factory that creates an execution strategy for different {@link io.servicetalk.router.api.RouteExecutionStrategy#id() id}s
         * @param supportedMessageCodings the set of allowed encodings
         * @deprecated Use {@link Builder#Builder(RouteExecutionStrategyFactory)}, {@link Builder#bufferDecoderGroup(BufferDecoderGroup)}, and {@link Builder#bufferEncoders(List)}.
         */
        @Deprecated
        public ServiceFactory(final BlockingHealthService service,
                final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory,
                final List<ContentCodec> supportedMessageCodings) {
            this(new Builder(strategyFactory, supportedMessageCodings).checkBlocking(service).watchBlocking(service));
        }

        public static final class Builder extends GrpcRoutes<HealthService> {
            private BufferDecoderGroup bufferDecoderGroup = EmptyBufferDecoderGroup.INSTANCE;

            private List<BufferEncoder> bufferEncoders = Collections.emptyList();

            private final List<ContentCodec> supportedMessageCodings;

            /**
             * Create a new instance.
             */
            public Builder() {
                this(Collections.emptyList());
            }

            /**
             * Create a new instance.
             *
             * @param supportedMessageCodings the set of allowed encodings
             * @deprecated Use {@link #bufferDecoderGroup(BufferDecoderGroup)} and {@link #bufferEncoders(List)}.
             */
            @Deprecated
            public Builder(final List<ContentCodec> supportedMessageCodings) {
                this.supportedMessageCodings = supportedMessageCodings;
            }

            /**
             * Create a new instance.
             *
             * @param strategyFactory a factory that creates an execution strategy for different {@link io.servicetalk.router.api.RouteExecutionStrategy#id() id}s
             * @deprecated use {@link #routeExecutionStrategyFactory(RouteExecutionStrategyFactory)} on the Builder instead.
             */
            @Deprecated
            public Builder(
                    final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory) {
                this(strategyFactory, Collections.emptyList());
            }

            /**
             * Create a new instance.
             *
             * @param strategyFactory a factory that creates an execution strategy for different {@link io.servicetalk.router.api.RouteExecutionStrategy#id() id}s
             * @param supportedMessageCodings the set of allowed encodings
             * @deprecated Use {@link #Builder(RouteExecutionStrategyFactory)}, {@link #bufferDecoderGroup(BufferDecoderGroup)}, and {@link #bufferEncoders(List)}.
             */
            @Deprecated
            public Builder(
                    final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory,
                    final List<ContentCodec> supportedMessageCodings) {
                super(strategyFactory);
                this.supportedMessageCodings = supportedMessageCodings;
            }

            public Builder bufferDecoderGroup(final BufferDecoderGroup bufferDecoderGroup) {
                this.bufferDecoderGroup = Objects.requireNonNull(bufferDecoderGroup);
                return this;
            }

            public Builder bufferEncoders(final List<BufferEncoder> bufferEncoders) {
                this.bufferEncoders = Objects.requireNonNull(bufferEncoders);
                return this;
            }

            @Override
            public Builder routeExecutionStrategyFactory(
                    final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory) {
                super.routeExecutionStrategyFactory(strategyFactory);
                return this;
            }

            public ServiceFactory build() {
                return new ServiceFactory(this);
            }

            @Override
            @Deprecated
            protected HealthServiceFromRoutes newServiceFromRoutes(
                    final GrpcRoutes.AllGrpcRoutes routes) {
                return new HealthServiceFromRoutes(routes);
            }

            public Builder check(final CheckRpc rpc) {
                Objects.requireNonNull(rpc);
                final GrpcRoutes.Route<HealthCheckRequest, HealthCheckResponse> route = GrpcRoutes.Route.wrap(rpc::check, rpc);
                if (supportedMessageCodings.isEmpty()) {
                    addRoute(rpc.getClass(), CheckRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addRoute(CheckRpc.PATH, rpc.getClass(), CheckRpc.methodDescriptor().javaMethodName(), route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            public Builder check(final GrpcExecutionStrategy strategy, final CheckRpc rpc) {
                Objects.requireNonNull(strategy);
                Objects.requireNonNull(rpc);
                final GrpcRoutes.Route<HealthCheckRequest, HealthCheckResponse> route = GrpcRoutes.Route.wrap(rpc::check, rpc);
                if (supportedMessageCodings.isEmpty()) {
                    addRoute(strategy, CheckRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addRoute(CheckRpc.PATH, strategy, route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            public Builder checkBlocking(final BlockingCheckRpc rpc) {
                Objects.requireNonNull(rpc);
                final GrpcRoutes.BlockingRoute<HealthCheckRequest, HealthCheckResponse> route = GrpcRoutes.BlockingRoute.wrap(rpc::check, rpc);
                if (supportedMessageCodings.isEmpty()) {
                    addBlockingRoute(rpc.getClass(), BlockingCheckRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addBlockingRoute(BlockingCheckRpc.PATH, rpc.getClass(), BlockingCheckRpc.methodDescriptor().javaMethodName(), route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            public Builder checkBlocking(final GrpcExecutionStrategy strategy,
                    final BlockingCheckRpc rpc) {
                Objects.requireNonNull(strategy);
                Objects.requireNonNull(rpc);
                final GrpcRoutes.BlockingRoute<HealthCheckRequest, HealthCheckResponse> route = GrpcRoutes.BlockingRoute.wrap(rpc::check, rpc);
                if (supportedMessageCodings.isEmpty()) {
                    addBlockingRoute(strategy, BlockingCheckRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addBlockingRoute(BlockingCheckRpc.PATH, strategy, route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            public Builder watch(final WatchRpc rpc) {
                Objects.requireNonNull(rpc);
                final GrpcRoutes.ResponseStreamingRoute<HealthCheckRequest, HealthCheckResponse> route = GrpcRoutes.ResponseStreamingRoute.wrap(rpc::watch, rpc);
                if (supportedMessageCodings.isEmpty()) {
                    addResponseStreamingRoute(rpc.getClass(), WatchRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addResponseStreamingRoute(WatchRpc.PATH, rpc.getClass(), WatchRpc.methodDescriptor().javaMethodName(), route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            public Builder watch(final GrpcExecutionStrategy strategy, final WatchRpc rpc) {
                Objects.requireNonNull(strategy);
                Objects.requireNonNull(rpc);
                final GrpcRoutes.ResponseStreamingRoute<HealthCheckRequest, HealthCheckResponse> route = GrpcRoutes.ResponseStreamingRoute.wrap(rpc::watch, rpc);
                if (supportedMessageCodings.isEmpty()) {
                    addResponseStreamingRoute(strategy, WatchRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addResponseStreamingRoute(WatchRpc.PATH, strategy, route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            public Builder watchBlocking(final BlockingWatchRpc rpc) {
                Objects.requireNonNull(rpc);
                final GrpcRoutes.BlockingResponseStreamingRoute<HealthCheckRequest, HealthCheckResponse> route = new GrpcRoutes.BlockingResponseStreamingRoute<HealthCheckRequest, HealthCheckResponse>() {
                    @Override
                    @Deprecated
                    public void handle(GrpcServiceContext ctx, HealthCheckRequest request,
                            GrpcPayloadWriter<HealthCheckResponse> responseWriter) throws
                            Exception {
                        rpc.watch(ctx, request, responseWriter);
                    }

                    @Override
                    public void handle(GrpcServiceContext ctx, HealthCheckRequest request,
                            BlockingStreamingGrpcServerResponse<HealthCheckResponse> response)
                            throws Exception {
                        rpc.watch(ctx, request, response);
                    }

                    @Override
                    public void close() throws Exception {
                        rpc.close();
                    }

                    @Override
                    public void closeGracefully() throws Exception {
                        rpc.closeGracefully();
                    }
                };
                if (supportedMessageCodings.isEmpty()) {
                    addBlockingResponseStreamingRoute(rpc.getClass(), BlockingWatchRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addBlockingResponseStreamingRoute(BlockingWatchRpc.PATH, rpc.getClass(), BlockingWatchRpc.methodDescriptor().javaMethodName(), route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            public Builder watchBlocking(final GrpcExecutionStrategy strategy,
                    final BlockingWatchRpc rpc) {
                Objects.requireNonNull(strategy);
                Objects.requireNonNull(rpc);
                final GrpcRoutes.BlockingResponseStreamingRoute<HealthCheckRequest, HealthCheckResponse> route = new GrpcRoutes.BlockingResponseStreamingRoute<HealthCheckRequest, HealthCheckResponse>() {
                    @Override
                    @Deprecated
                    public void handle(GrpcServiceContext ctx, HealthCheckRequest request,
                            GrpcPayloadWriter<HealthCheckResponse> responseWriter) throws
                            Exception {
                        rpc.watch(ctx, request, responseWriter);
                    }

                    @Override
                    public void handle(GrpcServiceContext ctx, HealthCheckRequest request,
                            BlockingStreamingGrpcServerResponse<HealthCheckResponse> response)
                            throws Exception {
                        rpc.watch(ctx, request, response);
                    }

                    @Override
                    public void close() throws Exception {
                        rpc.close();
                    }

                    @Override
                    public void closeGracefully() throws Exception {
                        rpc.closeGracefully();
                    }
                };
                if (supportedMessageCodings.isEmpty()) {
                    addBlockingResponseStreamingRoute(strategy, BlockingWatchRpc.methodDescriptor(), bufferDecoderGroup, bufferEncoders, route);
                } else {
                    addBlockingResponseStreamingRoute(BlockingWatchRpc.PATH, strategy, route, HealthCheckRequest.class, HealthCheckResponse.class, initSerializationProvider(supportedMessageCodings));
                }
                return this;
            }

            /**
             * Adds a {@link BlockingHealthService} implementation.
             *
             * @param service the {@link BlockingHealthService} implementation to add.
             * @return this.
             * @deprecated Use {@link #addBlockingService(io.servicetalk.health.v1.Health.BlockingHealthService)}.
             */
            @Deprecated
            public Builder addService(final BlockingHealthService service) {
                return addBlockingService(service);
            }

            public Builder addService(final HealthService service) {
                Objects.requireNonNull(service);
                check(service);
                watch(service);
                return this;
            }

            public Builder addBlockingService(final BlockingHealthService service) {
                Objects.requireNonNull(service);
                checkBlocking(service);
                watchBlocking(service);
                return this;
            }

            @Override
            @Deprecated
            protected void registerRoutes(final HealthService service) {
                check(service);
                watch(service);
            }

            @Deprecated
            private static final class HealthServiceFromRoutes implements HealthService {
                private final AsyncCloseable closeable;

                private final GrpcRoutes.Route<HealthCheckRequest, HealthCheckResponse> check;

                private final GrpcRoutes.ResponseStreamingRoute<HealthCheckRequest, HealthCheckResponse> watch;

                private HealthServiceFromRoutes(final GrpcRoutes.AllGrpcRoutes routes) {
                    closeable = routes;
                    check = routes.routeFor(CheckRpc.methodDescriptor().httpPath());
                    watch = routes.responseStreamingRouteFor(WatchRpc.methodDescriptor().httpPath());
                }

                @Override
                public Single<HealthCheckResponse> check(final GrpcServiceContext ctx,
                        final HealthCheckRequest request) {
                    return check.handle(ctx, request);
                }

                @Override
                public Publisher<HealthCheckResponse> watch(final GrpcServiceContext ctx,
                        final HealthCheckRequest request) {
                    return watch.handle(ctx, request);
                }

                @Override
                public Completable closeAsync() {
                    return closeable.closeAsync();
                }

                @Override
                public Completable closeAsyncGracefully() {
                    return closeable.closeAsyncGracefully();
                }
            }
        }
    }

    /**
     * @deprecated This class will be removed in the future in favor of direct usage of {@link GrpcClientMetadata}. Deprecation of {@link GrpcClientMetadata#path()} renders this type unnecessary.
     */
    @Deprecated
    public static final class CheckMetadata extends DefaultGrpcClientMetadata {
        /**
         * @deprecated Use {@link DefaultGrpcClientMetadata}.
         */
        @Deprecated
        public static final CheckMetadata INSTANCE = new CheckMetadata();

        private CheckMetadata(final GrpcClientMetadata metadata) {
            super(CheckRpc.PATH, metadata);
        }

        private CheckMetadata() {
            super(CheckRpc.PATH);
        }

        public CheckMetadata(final GrpcExecutionStrategy strategy) {
            super(CheckRpc.PATH, strategy);
        }

        public CheckMetadata(final Duration timeout) {
            super(CheckRpc.PATH, timeout);
        }

        public CheckMetadata(final ContentCodec requestEncoding) {
            super(CheckRpc.PATH, requestEncoding);
        }

        public CheckMetadata(final GrpcExecutionStrategy strategy,
                final ContentCodec requestEncoding) {
            super(CheckRpc.PATH, strategy, requestEncoding);
        }

        public CheckMetadata(final GrpcExecutionStrategy strategy,
                final ContentCodec requestEncoding, final Duration timeout) {
            super(CheckRpc.PATH, strategy, requestEncoding, timeout);
        }
    }

    /**
     * @deprecated This class will be removed in the future in favor of direct usage of {@link GrpcClientMetadata}. Deprecation of {@link GrpcClientMetadata#path()} renders this type unnecessary.
     */
    @Deprecated
    public static final class WatchMetadata extends DefaultGrpcClientMetadata {
        /**
         * @deprecated Use {@link DefaultGrpcClientMetadata}.
         */
        @Deprecated
        public static final WatchMetadata INSTANCE = new WatchMetadata();

        private WatchMetadata(final GrpcClientMetadata metadata) {
            super(WatchRpc.PATH, metadata);
        }

        private WatchMetadata() {
            super(WatchRpc.PATH);
        }

        public WatchMetadata(final GrpcExecutionStrategy strategy) {
            super(WatchRpc.PATH, strategy);
        }

        public WatchMetadata(final Duration timeout) {
            super(WatchRpc.PATH, timeout);
        }

        public WatchMetadata(final ContentCodec requestEncoding) {
            super(WatchRpc.PATH, requestEncoding);
        }

        public WatchMetadata(final GrpcExecutionStrategy strategy,
                final ContentCodec requestEncoding) {
            super(WatchRpc.PATH, strategy, requestEncoding);
        }

        public WatchMetadata(final GrpcExecutionStrategy strategy,
                final ContentCodec requestEncoding, final Duration timeout) {
            super(WatchRpc.PATH, strategy, requestEncoding, timeout);
        }
    }

    public interface HealthClient extends GrpcClient<BlockingHealthClient> {
        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @param request the request to send to the server.
         * @return a {@link Single} which completes when the response is received from the server.
         */
        Single<HealthCheckResponse> check(HealthCheckRequest request);

        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @param metadata the metadata associated with this client call.
         * @param request the request to send to the server.
         * @return a {@link Single} which completes when the response is received from the server.
         */
        default Single<HealthCheckResponse> check(GrpcClientMetadata metadata,
                HealthCheckRequest request) {
            return check(new CheckMetadata(metadata), request);
        }

        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @deprecated Use {@link #check(GrpcClientMetadata,HealthCheckRequest)}.
         * @param metadata the metadata associated with this client call.
         * @param request the request to send to the server.
         * @return a {@link Single} which completes when the response is received from the server.
         */
        @Deprecated
        default Single<HealthCheckResponse> check(CheckMetadata metadata,
                HealthCheckRequest request) {
            return Single.failed(new UnsupportedOperationException("This method is not implemented by " + getClass() + ". Consider migrating Consider migrating to an alternative method or implement this method if it's required temporarily."));
        }

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @param request the request to send to the server.
         * @return used to read a stream of type {@link HealthCheckResponse} from the server.
         */
        Publisher<HealthCheckResponse> watch(HealthCheckRequest request);

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @param metadata the metadata associated with this client call.
         * @param request the request to send to the server.
         * @return used to read a stream of type {@link HealthCheckResponse} from the server.
         */
        default Publisher<HealthCheckResponse> watch(GrpcClientMetadata metadata,
                HealthCheckRequest request) {
            return watch(new WatchMetadata(metadata), request);
        }

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @deprecated Use {@link #watch(GrpcClientMetadata,HealthCheckRequest)}.
         * @param metadata the metadata associated with this client call.
         * @param request the request to send to the server.
         * @return used to read a stream of type {@link HealthCheckResponse} from the server.
         */
        @Deprecated
        default Publisher<HealthCheckResponse> watch(WatchMetadata metadata,
                HealthCheckRequest request) {
            return Publisher.failed(new UnsupportedOperationException("This method is not implemented by " + getClass() + ". Consider migrating Consider migrating to an alternative method or implement this method if it's required temporarily."));
        }

        @Override
        default BlockingHealthClient asBlockingClient() {
            return new HealthClientToBlockingHealthClient(this);
        }
    }

    public interface BlockingHealthClient extends BlockingGrpcClient<HealthClient> {
        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @param request the request from the client.
         * @return the response from the server.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        HealthCheckResponse check(HealthCheckRequest request) throws Exception;

        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @deprecated Use {@link #check(GrpcClientMetadata,HealthCheckRequest)}.
         * @param metadata the metadata associated with this client call.
         * @param request the request from the client.
         * @return the response from the server.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        @Deprecated
        default HealthCheckResponse check(CheckMetadata metadata, HealthCheckRequest request) throws
                Exception {
            throw new UnsupportedOperationException("This method is not implemented by " + getClass() + ". Consider migrating to an alternative method or implement this method if it's required temporarily.");
        }

        /**
         * <pre>
         *  If the requested service is unknown, the call will fail with status
         *  NOT_FOUND.
         * </pre>
         *
         * @param metadata the metadata associated with this client call.
         * @param request the request from the client.
         * @return the response from the server.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        default HealthCheckResponse check(GrpcClientMetadata metadata, HealthCheckRequest request)
                throws Exception {
            return check(new CheckMetadata(metadata), request);
        }

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @param request the request from the client.
         * @return used to read the response stream of type {@link HealthCheckResponse} from the server.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        BlockingIterable<HealthCheckResponse> watch(HealthCheckRequest request) throws Exception;

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @deprecated Use {@link #watch(GrpcClientMetadata,HealthCheckRequest)}.
         * @param metadata the metadata associated with this client call.
         * @param request the request from the client.
         * @return used to read the response stream of type {@link HealthCheckResponse} from the server.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        @Deprecated
        default BlockingIterable<HealthCheckResponse> watch(WatchMetadata metadata,
                HealthCheckRequest request) throws Exception {
            throw new UnsupportedOperationException("This method is not implemented by " + getClass() + ". Consider migrating to an alternative method or implement this method if it's required temporarily.");
        }

        /**
         * <pre>
         *  Performs a watch for the serving status of the requested service.
         *  The server will immediately send back a message indicating the current
         *  serving status.  It will then subsequently send a new message whenever
         *  the service's serving status changes.
         *
         *  If the requested service is unknown when the call is received, the
         *  server will send a message setting the serving status to
         *  SERVICE_UNKNOWN but will *not* terminate the call.  If at some
         *  future point, the serving status of the service becomes known, the
         *  server will send a new message with the service's serving status.
         *
         *  If the call terminates with status UNIMPLEMENTED, then clients
         *  should assume this method is not supported and should not retry the
         *  call.  If the call terminates with any other status (including OK),
         *  clients should retry the call with appropriate exponential backoff.
         * </pre>
         *
         * @param metadata the metadata associated with this client call.
         * @param request the request from the client.
         * @return used to read the response stream of type {@link HealthCheckResponse} from the server.
         * @throws Exception if an unexpected application error occurs.
         * @throws io.servicetalk.grpc.api.GrpcStatusException if an expected application exception occurs. Its contents will be serialized and propagated to the peer.
         */
        default BlockingIterable<HealthCheckResponse> watch(GrpcClientMetadata metadata,
                HealthCheckRequest request) throws Exception {
            return watch(new WatchMetadata(metadata), request);
        }
    }

    private static final class HealthClientToBlockingHealthClient implements BlockingHealthClient {
        private final HealthClient client;

        HealthClientToBlockingHealthClient(final HealthClient client) {
            this.client = client;
        }

        @Override
        public HealthClient asClient() {
            return client;
        }

        @Override
        public GrpcExecutionContext executionContext() {
            return client.executionContext();
        }

        @Override
        public void close() throws Exception {
            client.close();
        }

        @Override
        public HealthCheckResponse check(final HealthCheckRequest request) throws Exception {
            return client.check(request).toFuture().get();
        }

        @Override
        public HealthCheckResponse check(final GrpcClientMetadata metadata,
                final HealthCheckRequest request) throws Exception {
            return client.check(metadata, request).toFuture().get();
        }

        @Deprecated
        @Override
        public HealthCheckResponse check(final CheckMetadata metadata,
                final HealthCheckRequest request) throws Exception {
            return client.check(metadata, request).toFuture().get();
        }

        @Override
        public BlockingIterable<HealthCheckResponse> watch(final HealthCheckRequest request) throws
                Exception {
            return client.watch(request).toIterable();
        }

        @Override
        public BlockingIterable<HealthCheckResponse> watch(final GrpcClientMetadata metadata,
                final HealthCheckRequest request) throws Exception {
            return client.watch(metadata, request).toIterable();
        }

        @Deprecated
        @Override
        public BlockingIterable<HealthCheckResponse> watch(final WatchMetadata metadata,
                final HealthCheckRequest request) throws Exception {
            return client.watch(metadata, request).toIterable();
        }
    }

    public static class ClientFactory extends GrpcClientFactory<HealthClient, BlockingHealthClient> {
        @Override
        protected HealthClient newClient(final GrpcClientCallFactory factory) {
            return new DefaultHealthClient(factory, supportedMessageCodings(), bufferDecoderGroup());
        }

        @Override
        protected BlockingHealthClient newBlockingClient(final GrpcClientCallFactory factory) {
            return new DefaultBlockingHealthClient(factory, supportedMessageCodings(), bufferDecoderGroup());
        }

        private static final class DefaultHealthClient implements HealthClient {
            private final GrpcClientCallFactory factory;

            private final BufferDecoderGroup bufferDecoderGroup;

            private final List<ContentCodec> supportedMessageCodings;

            private final GrpcClientCallFactory.ClientCall<HealthCheckRequest, HealthCheckResponse> checkCall;

            private final GrpcClientCallFactory.ResponseStreamingClientCall<HealthCheckRequest, HealthCheckResponse> watchCall;

            private DefaultHealthClient(final GrpcClientCallFactory factory,
                    final List<ContentCodec> supportedMessageCodings,
                    final BufferDecoderGroup bufferDecoderGroup) {
                this.supportedMessageCodings = supportedMessageCodings;
                this.factory = factory;
                this.bufferDecoderGroup = bufferDecoderGroup;
                if (supportedMessageCodings.isEmpty()) {
                    checkCall = factory.newCall(CheckRpc.methodDescriptor(), bufferDecoderGroup);
                } else {
                    checkCall = factory.newCall(initSerializationProvider(supportedMessageCodings), HealthCheckRequest.class, HealthCheckResponse.class);
                }
                if (supportedMessageCodings.isEmpty()) {
                    watchCall = factory.newResponseStreamingCall(WatchRpc.methodDescriptor(), bufferDecoderGroup);
                } else {
                    watchCall = factory.newResponseStreamingCall(initSerializationProvider(supportedMessageCodings), HealthCheckRequest.class, HealthCheckResponse.class);
                }
            }

            @Override
            public BlockingHealthClient asBlockingClient() {
                return new DefaultBlockingHealthClient(factory, supportedMessageCodings, bufferDecoderGroup);
            }

            @Override
            public GrpcExecutionContext executionContext() {
                return factory.executionContext();
            }

            @Override
            public Completable onClose() {
                return factory.onClose();
            }

            @Override
            public Completable onClosing() {
                return factory.onClosing();
            }

            @Override
            public Completable closeAsync() {
                return factory.closeAsync();
            }

            @Override
            public Completable closeAsyncGracefully() {
                return factory.closeAsyncGracefully();
            }

            @Override
            public void close() throws Exception {
                factory.closeAsync().toFuture().get();
            }

            @Override
            public void closeGracefully() throws Exception {
                factory.closeAsyncGracefully().toFuture().get();
            }

            @Override
            public Single<HealthCheckResponse> check(final GrpcClientMetadata metadata,
                    final HealthCheckRequest request) {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return checkCall.request(metadata, request);
            }

            @Deprecated
            @Override
            public Single<HealthCheckResponse> check(final CheckMetadata metadata,
                    final HealthCheckRequest request) {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return checkCall.request(metadata, request);
            }

            @Override
            public Single<HealthCheckResponse> check(final HealthCheckRequest request) {
                return check(supportedMessageCodings.isEmpty() ? new DefaultGrpcClientMetadata() : new CheckMetadata(), request);
            }

            @Override
            public Publisher<HealthCheckResponse> watch(final GrpcClientMetadata metadata,
                    final HealthCheckRequest request) {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return watchCall.request(metadata, request);
            }

            @Deprecated
            @Override
            public Publisher<HealthCheckResponse> watch(final WatchMetadata metadata,
                    final HealthCheckRequest request) {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return watchCall.request(metadata, request);
            }

            @Override
            public Publisher<HealthCheckResponse> watch(final HealthCheckRequest request) {
                return watch(supportedMessageCodings.isEmpty() ? new DefaultGrpcClientMetadata() : new WatchMetadata(), request);
            }
        }

        private static final class DefaultBlockingHealthClient implements BlockingHealthClient {
            private final GrpcClientCallFactory factory;

            private final BufferDecoderGroup bufferDecoderGroup;

            private final List<ContentCodec> supportedMessageCodings;

            private final GrpcClientCallFactory.BlockingClientCall<HealthCheckRequest, HealthCheckResponse> checkCall;

            private final GrpcClientCallFactory.BlockingResponseStreamingClientCall<HealthCheckRequest, HealthCheckResponse> watchCall;

            private DefaultBlockingHealthClient(final GrpcClientCallFactory factory,
                    final List<ContentCodec> supportedMessageCodings,
                    final BufferDecoderGroup bufferDecoderGroup) {
                this.supportedMessageCodings = supportedMessageCodings;
                this.factory = factory;
                this.bufferDecoderGroup = bufferDecoderGroup;
                if (supportedMessageCodings.isEmpty()) {
                    checkCall = factory.newBlockingCall(BlockingCheckRpc.methodDescriptor(), bufferDecoderGroup);
                } else {
                    checkCall = factory.newBlockingCall(initSerializationProvider(supportedMessageCodings), HealthCheckRequest.class, HealthCheckResponse.class);
                }
                if (supportedMessageCodings.isEmpty()) {
                    watchCall = factory.newBlockingResponseStreamingCall(BlockingWatchRpc.methodDescriptor(), bufferDecoderGroup);
                } else {
                    watchCall = factory.newBlockingResponseStreamingCall(initSerializationProvider(supportedMessageCodings), HealthCheckRequest.class, HealthCheckResponse.class);
                }
            }

            @Override
            public HealthClient asClient() {
                return new DefaultHealthClient(factory, supportedMessageCodings, bufferDecoderGroup);
            }

            @Override
            public GrpcExecutionContext executionContext() {
                return factory.executionContext();
            }

            @Override
            public void close() throws Exception {
                factory.closeAsync().toFuture().get();
            }

            @Override
            public void closeGracefully() throws Exception {
                factory.closeAsyncGracefully().toFuture().get();
            }

            @Override
            public HealthCheckResponse check(final GrpcClientMetadata metadata,
                    final HealthCheckRequest request) throws Exception {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return checkCall.request(metadata, request);
            }

            @Deprecated
            @Override
            public HealthCheckResponse check(final CheckMetadata metadata,
                    final HealthCheckRequest request) throws Exception {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return checkCall.request(metadata, request);
            }

            @Override
            public HealthCheckResponse check(final HealthCheckRequest request) throws Exception {
                return check(supportedMessageCodings.isEmpty() ? new DefaultGrpcClientMetadata() : new CheckMetadata(), request);
            }

            @Override
            public BlockingIterable<HealthCheckResponse> watch(final GrpcClientMetadata metadata,
                    final HealthCheckRequest request) throws Exception {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return watchCall.request(metadata, request);
            }

            @Deprecated
            @Override
            public BlockingIterable<HealthCheckResponse> watch(final WatchMetadata metadata,
                    final HealthCheckRequest request) throws Exception {
                Objects.requireNonNull(metadata);
                Objects.requireNonNull(request);
                return watchCall.request(metadata, request);
            }

            @Override
            public BlockingIterable<HealthCheckResponse> watch(final HealthCheckRequest request)
                    throws Exception {
                return watch(supportedMessageCodings.isEmpty() ? new DefaultGrpcClientMetadata() : new WatchMetadata(), request);
            }
        }
    }

    // @@protoc_insertion_point(service_scope:grpc.health.v1.Health)
}
