/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.health;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.grpc.api.GrpcStatus;
import io.servicetalk.grpc.api.GrpcStatusCode;
import io.servicetalk.grpc.api.GrpcStatusException;
import io.servicetalk.health.v1.Health;
import io.servicetalk.health.v1.HealthCheckRequest;
import io.servicetalk.health.v1.HealthCheckResponse;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

public final class DefaultHealthService
implements Health.HealthService {
    public static final String OVERALL_SERVICE_NAME = "";
    private final Map<String, HealthValue> serviceToStatusMap = new ConcurrentHashMap<String, HealthValue>();
    private final Predicate<String> watchAllowed;
    private final Lock lock = new ReentrantLock();
    private boolean terminated;

    public DefaultHealthService() {
        this(service -> true);
    }

    public DefaultHealthService(Predicate<String> watchAllowed) {
        this.watchAllowed = Objects.requireNonNull(watchAllowed);
        this.serviceToStatusMap.put(OVERALL_SERVICE_NAME, new HealthValue(HealthCheckResponse.ServingStatus.SERVING));
    }

    @Override
    public Single<HealthCheckResponse> check(GrpcServiceContext ctx, HealthCheckRequest request) {
        HealthValue health = this.serviceToStatusMap.get(request.getService());
        if (health == null) {
            return Single.failed((Throwable)new GrpcStatusException(new GrpcStatus(GrpcStatusCode.NOT_FOUND, "unknown service: " + request.getService())));
        }
        return Single.succeeded((Object)health.last);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Publisher<HealthCheckResponse> watch(GrpcServiceContext ctx, HealthCheckRequest request) {
        HealthValue healthValue = this.serviceToStatusMap.get(request.getService());
        if (healthValue == null) {
            if (!this.watchAllowed.test(request.getService())) {
                return Publisher.failed((Throwable)new GrpcStatusException(new GrpcStatus(GrpcStatusCode.FAILED_PRECONDITION, "watch not allowed for service " + request.getService())));
            }
            this.lock.lock();
            try {
                if (this.terminated) {
                    Publisher publisher = Publisher.from((Object)HealthCheckResponse.newBuilder().setStatus(HealthCheckResponse.ServingStatus.NOT_SERVING).build());
                    return publisher;
                }
                healthValue = this.serviceToStatusMap.computeIfAbsent(request.getService(), __ -> new HealthValue(HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN));
            }
            finally {
                this.lock.unlock();
            }
        }
        return Publisher.from((Object)healthValue.last).concat(healthValue.publisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatus(String service, HealthCheckResponse.ServingStatus status) {
        HealthValue healthValue;
        HealthCheckResponse resp;
        this.lock.lock();
        try {
            if (this.terminated) {
                boolean bl = false;
                return bl;
            }
            resp = HealthCheckResponse.newBuilder().setStatus(status).build();
            healthValue = this.serviceToStatusMap.computeIfAbsent(service, __ -> new HealthValue(resp));
        }
        finally {
            this.lock.unlock();
        }
        healthValue.next(resp);
        return true;
    }

    public boolean clearStatus(String service) {
        HealthValue healthValue = this.serviceToStatusMap.remove(service);
        if (healthValue != null) {
            healthValue.completeMultipleTerminalSafe(HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN);
            return true;
        }
        return false;
    }

    public boolean terminate() {
        this.lock.lock();
        try {
            if (this.terminated) {
                boolean bl = false;
                return bl;
            }
            this.terminated = true;
        }
        finally {
            this.lock.unlock();
        }
        for (HealthValue healthValue : this.serviceToStatusMap.values()) {
            healthValue.completeMultipleTerminalSafe(HealthCheckResponse.ServingStatus.NOT_SERVING);
        }
        return true;
    }

    private static final class HealthValue {
        private final PublisherSource.Processor<HealthCheckResponse, HealthCheckResponse> processor = Processors.newPublisherProcessorDropHeadOnOverflow((int)4);
        private final Publisher<HealthCheckResponse> publisher = SourceAdapters.fromSource(this.processor).multicast(1, false);
        private volatile HealthCheckResponse last;

        private HealthValue(HealthCheckResponse initialState) {
            this.last = initialState;
        }

        private HealthValue(HealthCheckResponse.ServingStatus status) {
            this(HealthCheckResponse.newBuilder().setStatus(status).build());
        }

        void next(HealthCheckResponse response) {
            this.last = response;
            this.processor.onNext((Object)response);
        }

        void completeMultipleTerminalSafe(HealthCheckResponse.ServingStatus status) {
            this.next(HealthCheckResponse.newBuilder().setStatus(status).build());
            this.processor.onComplete();
        }
    }
}

