/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.encoding.api.BufferEncoderDecoder;
import io.servicetalk.encoding.netty.DefaultBufferEncoderDecoder;
import io.servicetalk.encoding.netty.NettyCompression;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;

public final class NettyBufferEncoders {
    private static final CharSequence GZIP = CharSequences.newAsciiString((CharSequence)"gzip");
    private static final CharSequence DEFLATE = CharSequences.newAsciiString((CharSequence)"deflate");
    private static final BufferEncoderDecoder DEFAULT_GZIP = NettyBufferEncoders.bufferEncoder(NettyCompression.gzipDefault(), NettyCompression.gzipDefaultStreaming(), GZIP);
    private static final BufferEncoderDecoder DEFAULT_DEFLATE = NettyBufferEncoders.bufferEncoder(NettyCompression.deflateDefault(), NettyCompression.deflateDefaultStreaming(), DEFLATE);

    private NettyBufferEncoders() {
    }

    public static BufferEncoderDecoder gzipDefault() {
        return DEFAULT_GZIP;
    }

    public static BufferEncoderDecoder deflateDefault() {
        return DEFAULT_DEFLATE;
    }

    public static BufferEncoderDecoder bufferEncoder(SerializerDeserializer<Buffer> compressor, StreamingSerializerDeserializer<Buffer> streamingCompressor, CharSequence encodingName) {
        return new DefaultBufferEncoderDecoder(compressor, streamingCompressor, encodingName);
    }
}

