/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.PlatformDependent;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.encoding.api.BufferEncodingException;
import io.servicetalk.serializer.api.SerializerDeserializer;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyCompressionSerializer
implements SerializerDeserializer<Buffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyCompressionSerializer.class);
    private final Supplier<MessageToByteEncoder<ByteBuf>> encoderSupplier;
    private final Supplier<ByteToMessageDecoder> decoderSupplier;

    NettyCompressionSerializer(Supplier<MessageToByteEncoder<ByteBuf>> encoderSupplier, Supplier<ByteToMessageDecoder> decoderSupplier) {
        this.encoderSupplier = Objects.requireNonNull(encoderSupplier);
        this.decoderSupplier = Objects.requireNonNull(decoderSupplier);
    }

    public void serialize(Buffer toSerialize, BufferAllocator allocator, Buffer buffer) {
        ByteBuf nettyDst = BufferUtils.toByteBuf((Buffer)buffer);
        MessageToByteEncoder<ByteBuf> encoder = this.encoderSupplier.get();
        EmbeddedChannel channel = NettyCompressionSerializer.newEmbeddedChannel(encoder, allocator);
        try {
            NettyCompressionSerializer.writeAndUpdateIndex(channel, toSerialize, false);
            NettyCompressionSerializer.preparePendingData(channel);
            NettyCompressionSerializer.drainChannelQueueToSingleBuffer(channel.outboundMessages(), nettyDst);
            NettyCompressionSerializer.cleanup(channel);
        }
        catch (Throwable e) {
            NettyCompressionSerializer.safeCleanup(channel);
            throw new BufferEncodingException("Unexpected exception during encoding", e);
        }
    }

    public Buffer serialize(Buffer toSerialize, BufferAllocator allocator) {
        Buffer buffer = allocator.newBuffer(toSerialize.readableBytes());
        this.serialize(toSerialize, allocator, buffer);
        return buffer;
    }

    public Buffer deserialize(Buffer serializedData, BufferAllocator allocator) {
        Buffer buffer = allocator.newBuffer(serializedData.readableBytes());
        ByteBuf nettyDst = BufferUtils.toByteBuf((Buffer)buffer);
        ByteToMessageDecoder decoder = this.decoderSupplier.get();
        EmbeddedChannel channel = NettyCompressionSerializer.newEmbeddedChannel((ChannelHandler)decoder, allocator);
        try {
            NettyCompressionSerializer.writeAndUpdateIndex(channel, serializedData, true);
            NettyCompressionSerializer.drainChannelQueueToSingleBuffer(channel.inboundMessages(), nettyDst);
            NettyCompressionSerializer.cleanup(channel);
            return buffer;
        }
        catch (Throwable e) {
            NettyCompressionSerializer.safeCleanup(channel);
            throw new BufferEncodingException("Unexpected exception during decoding", e);
        }
    }

    static void writeAndUpdateIndex(EmbeddedChannel channel, Buffer toSerialize, boolean inbound) {
        ByteBuf byteBuf = BufferUtils.extractByteBufOrCreate((Buffer)toSerialize);
        int beforeReadableBytes = byteBuf.readableBytes();
        if (inbound) {
            channel.writeInbound(new Object[]{byteBuf});
        } else {
            channel.writeOutbound(new Object[]{byteBuf});
        }
        if (byteBuf.readableBytes() != toSerialize.readableBytes()) {
            toSerialize.skipBytes(byteBuf.readableBytes() - beforeReadableBytes);
        }
    }

    @Nullable
    static void drainChannelQueueToSingleBuffer(Queue<Object> queue, ByteBuf nettyDst) {
        ByteBuf buf;
        while ((buf = (ByteBuf)queue.poll()) != null) {
            try {
                nettyDst.writeBytes(buf);
            }
            finally {
                buf.release();
            }
        }
    }

    private static EmbeddedChannel newEmbeddedChannel(ChannelHandler handler, BufferAllocator allocator) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        channel.config().setAllocator(BufferUtils.getByteBufAllocator((BufferAllocator)allocator));
        return channel;
    }

    static void preparePendingData(EmbeddedChannel channel) {
        try {
            channel.close().sync().get();
            channel.checkException();
        }
        catch (InterruptedException | ExecutionException ex) {
            PlatformDependent.throwException((Throwable)ex);
        }
    }

    static void cleanup(EmbeddedChannel channel) {
        boolean wasNotEmpty = channel.finishAndReleaseAll();
        assert (!wasNotEmpty);
    }

    static void safeCleanup(EmbeddedChannel channel) {
        try {
            NettyCompressionSerializer.cleanup(channel);
        }
        catch (AssertionError error) {
            throw error;
        }
        catch (Throwable t) {
            LOGGER.debug("Error while closing embedded channel", t);
        }
    }
}

