/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.encoding.netty.DeflateCompressionBuilder;
import io.servicetalk.encoding.netty.GzipCompressionBuilder;
import io.servicetalk.encoding.netty.ZipCompressionBuilder;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;

public final class NettyCompression {
    private static final SerializerDeserializer<Buffer> DEFAULT_GZIP = NettyCompression.gzip().build();
    private static final SerializerDeserializer<Buffer> DEFAULT_DEFLATE = NettyCompression.deflate().build();
    private static final StreamingSerializerDeserializer<Buffer> DEFAULT_STREAM_GZIP = NettyCompression.gzip().buildStreaming();
    private static final StreamingSerializerDeserializer<Buffer> DEFAULT_STREAM_DEFLATE = NettyCompression.deflate().buildStreaming();

    private NettyCompression() {
    }

    public static SerializerDeserializer<Buffer> gzipDefault() {
        return DEFAULT_GZIP;
    }

    public static StreamingSerializerDeserializer<Buffer> gzipDefaultStreaming() {
        return DEFAULT_STREAM_GZIP;
    }

    public static ZipCompressionBuilder gzip() {
        return new GzipCompressionBuilder();
    }

    public static SerializerDeserializer<Buffer> deflateDefault() {
        return DEFAULT_DEFLATE;
    }

    public static StreamingSerializerDeserializer<Buffer> deflateDefaultStreaming() {
        return DEFAULT_STREAM_DEFLATE;
    }

    public static ZipCompressionBuilder deflate() {
        return new DeflateCompressionBuilder();
    }
}

