/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;

public abstract class ZipCompressionBuilder {
    private static final int DEFAULT_MAX_CHUNK_SIZE = 0x400000;
    private int maxChunkSize = 0x400000;
    private int compressionLevel = 6;

    ZipCompressionBuilder() {
    }

    public final ZipCompressionBuilder withCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressionLevel = compressionLevel;
        return this;
    }

    public final ZipCompressionBuilder maxChunkSize(int maxChunkSize) {
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize: " + maxChunkSize + " (expected > 0)");
        }
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public abstract SerializerDeserializer<Buffer> build();

    public abstract StreamingSerializerDeserializer<Buffer> buildStreaming();

    final int compressionLevel() {
        return this.compressionLevel;
    }

    final int maxChunkSize() {
        return this.maxChunkSize;
    }
}

