/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.api.internal;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.Identity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class HeaderUtils {
    private static final List<ContentCodec> NONE_CONTENT_ENCODING_SINGLETON = Collections.singletonList(Identity.identity());

    private HeaderUtils() {
    }

    @Nullable
    public static ContentCodec negotiateAcceptedEncoding(@Nullable CharSequence acceptEncodingHeaderValue, List<ContentCodec> serverSupportedEncodings) {
        if (serverSupportedEncodings.isEmpty() || serverSupportedEncodings.size() == 1 && serverSupportedEncodings.contains(Identity.identity())) {
            return null;
        }
        List<ContentCodec> clientSupportedEncodings = HeaderUtils.parseAcceptEncoding(acceptEncodingHeaderValue, serverSupportedEncodings);
        return HeaderUtils.negotiateAcceptedEncoding(clientSupportedEncodings, serverSupportedEncodings);
    }

    @Nullable
    public static ContentCodec negotiateAcceptedEncoding(List<ContentCodec> clientSupportedEncodings, List<ContentCodec> serverSupportedEncodings) {
        if (clientSupportedEncodings == NONE_CONTENT_ENCODING_SINGLETON || clientSupportedEncodings.size() == 1 && clientSupportedEncodings.contains(Identity.identity())) {
            return null;
        }
        for (ContentCodec encoding : serverSupportedEncodings) {
            if (encoding == Identity.identity() || !clientSupportedEncodings.contains(encoding)) continue;
            return encoding;
        }
        return null;
    }

    private static List<ContentCodec> parseAcceptEncoding(@Nullable CharSequence acceptEncodingHeaderValue, List<ContentCodec> allowedEncodings) {
        if (acceptEncodingHeaderValue == null || acceptEncodingHeaderValue.length() == 0) {
            return NONE_CONTENT_ENCODING_SINGLETON;
        }
        ArrayList<ContentCodec> knownEncodings = new ArrayList<ContentCodec>();
        List acceptEncodingValues = CharSequences.split((CharSequence)acceptEncodingHeaderValue, (char)',', (boolean)true);
        for (CharSequence val : acceptEncodingValues) {
            ContentCodec enc = HeaderUtils.encodingFor(allowedEncodings, val);
            if (enc == null) continue;
            knownEncodings.add(enc);
        }
        return knownEncodings;
    }

    @Nullable
    public static ContentCodec encodingFor(Collection<ContentCodec> allowedList, @Nullable CharSequence name) {
        Objects.requireNonNull(allowedList);
        if (name == null || name.length() == 0) {
            return null;
        }
        if (CharSequences.contentEquals((CharSequence)name, (CharSequence)Identity.identity().name())) {
            return Identity.identity();
        }
        for (ContentCodec enumEnc : allowedList) {
            if (!HeaderUtils.startsWith(name, enumEnc.name())) continue;
            return enumEnc;
        }
        return null;
    }

    private static boolean startsWith(CharSequence string, CharSequence prefix) {
        return CharSequences.regionMatches((CharSequence)string, (boolean)true, (int)0, (CharSequence)prefix, (int)0, (int)prefix.length());
    }
}

