/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.TimeSource;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.api.RepeatStrategies;
import io.servicetalk.concurrent.api.internal.SubscribablePublisher;
import io.servicetalk.concurrent.internal.CancelImmediatelySubscriber;
import io.servicetalk.concurrent.internal.DuplicateSubscribeException;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.RejectedSubscribeError;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.dns.discovery.netty.DefaultResolutionResult;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.dns.discovery.netty.DnsClients;
import io.servicetalk.dns.discovery.netty.DnsResolverAddressTypes;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStream;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererObserver;
import io.servicetalk.dns.discovery.netty.MinTtlCache;
import io.servicetalk.dns.discovery.netty.ServiceDiscovererUtils;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutors;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultDnsClient
implements DnsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDnsClient.class);
    private static final Comparator<InetAddress> INET_ADDRESS_COMPARATOR = Comparator.comparing(o -> ByteBuffer.wrap(o.getAddress()));
    private static final Comparator<HostAndPort> HOST_AND_PORT_COMPARATOR = Comparator.comparing(HostAndPort::hostName).thenComparingInt(HostAndPort::port);
    private static final Cancellable TERMINATED = () -> {};
    private final EventLoopAwareNettyIoExecutor nettyIoExecutor;
    private final DnsNameResolver resolver;
    private final MinTtlCache ttlCache;
    private final ListenableAsyncCloseable asyncCloseable;
    @Nullable
    private final DnsServiceDiscovererObserver observer;
    private final ServiceDiscovererEvent.Status missingRecordStatus;
    private final IntFunction<? extends Completable> srvHostNameRepeater;
    private final int srvConcurrency;
    private final boolean srvFilterDuplicateEvents;
    private final boolean inactiveEventsOnError;
    private boolean closed;

    DefaultDnsClient(IoExecutor ioExecutor, int minTTL, int srvConcurrency, boolean inactiveEventsOnError, boolean completeOncePreferredResolved, boolean srvFilterDuplicateEvents, Duration srvHostNameRepeatInitialDelay, Duration srvHostNameRepeatJitter, @Nullable Integer maxUdpPayloadSize, @Nullable Integer ndots, @Nullable Boolean optResourceEnabled, @Nullable Duration queryTimeout, @Nullable DnsResolverAddressTypes dnsResolverAddressTypes, @Nullable DnsServerAddressStreamProvider dnsServerAddressStreamProvider, @Nullable DnsServiceDiscovererObserver observer, ServiceDiscovererEvent.Status missingRecordStatus) {
        if (srvConcurrency <= 0) {
            throw new IllegalArgumentException("srvConcurrency: " + srvConcurrency + " (expected >0)");
        }
        this.srvConcurrency = srvConcurrency;
        this.srvFilterDuplicateEvents = srvFilterDuplicateEvents;
        this.inactiveEventsOnError = inactiveEventsOnError;
        this.nettyIoExecutor = EventLoopAwareNettyIoExecutors.toEventLoopAwareNettyIoExecutor((IoExecutor)ioExecutor).next();
        this.srvHostNameRepeater = RepeatStrategies.repeatWithConstantBackoffDeltaJitter((Duration)srvHostNameRepeatInitialDelay, (Duration)srvHostNameRepeatJitter, (Executor)this.nettyIoExecutor);
        this.ttlCache = new MinTtlCache((DnsCache)new DefaultDnsCache(minTTL, Integer.MAX_VALUE, minTTL), minTTL, (TimeSource)this.nettyIoExecutor);
        this.observer = observer;
        this.missingRecordStatus = missingRecordStatus;
        this.asyncCloseable = AsyncCloseables.toAsyncCloseable(graceful -> {
            if (this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                this.closeAsync0();
                return Completable.completed();
            }
            return this.nettyIoExecutor.submit(this::closeAsync0);
        });
        EventLoop eventLoop = this.nettyIoExecutor.eventLoopGroup().next();
        Class socketChannelClass = BuilderUtils.socketChannel((EventLoopGroup)eventLoop, InetSocketAddress.class);
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(eventLoop).resolveCache((DnsCache)this.ttlCache).channelType(BuilderUtils.datagramChannel((EventLoopGroup)eventLoop)).socketChannelType(socketChannelClass).completeOncePreferredResolved(completeOncePreferredResolved);
        if (queryTimeout != null) {
            builder.queryTimeoutMillis(queryTimeout.toMillis());
        }
        if (maxUdpPayloadSize != null) {
            builder.maxPayloadSize(maxUdpPayloadSize.intValue());
        }
        if (ndots != null) {
            builder.ndots(ndots.intValue());
        }
        if (optResourceEnabled != null) {
            builder.optResourceEnabled(optResourceEnabled.booleanValue());
        }
        if (dnsServerAddressStreamProvider != null) {
            builder.nameServerProvider(DefaultDnsClient.toNettyType(dnsServerAddressStreamProvider));
        }
        if (dnsResolverAddressTypes != null) {
            builder.resolvedAddressTypes(DefaultDnsClient.toNettyType(dnsResolverAddressTypes));
        }
        this.resolver = builder.build();
    }

    @Nullable
    private DnsServiceDiscovererObserver.DnsDiscoveryObserver newDiscoveryObserver(String address) {
        if (this.observer == null) {
            return null;
        }
        try {
            return this.observer.onNewDiscovery(address);
        }
        catch (Throwable unexpected) {
            LOGGER.warn("Unexpected exception from {} while reporting new DNS discovery for {}", new Object[]{this.observer, address, unexpected});
            return null;
        }
    }

    @Override
    public Publisher<Collection<ServiceDiscovererEvent<InetAddress>>> dnsQuery(String address) {
        Objects.requireNonNull(address);
        return Publisher.defer(() -> {
            Publisher<Collection<ServiceDiscovererEvent<InetAddress>>> pub = new Publisher<Collection<ServiceDiscovererEvent<InetAddress>>>(address, this.newDiscoveryObserver(address));
            return this.inactiveEventsOnError ? DefaultDnsClient.recoverWithInactiveEvents(pub, false) : pub;
        });
    }

    @Override
    public Publisher<Collection<ServiceDiscovererEvent<InetSocketAddress>>> dnsSrvQuery(String serviceName) {
        Objects.requireNonNull(serviceName);
        return Publisher.defer(() -> {
            HashMap aRecordMap = new HashMap(8);
            HashMap availableAddresses = this.srvFilterDuplicateEvents ? new HashMap(8) : Collections.emptyMap();
            DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver = this.newDiscoveryObserver(serviceName);
            return DefaultDnsClient.recoverWithInactiveEvents(new SrvRecordPublisher(serviceName, discoveryObserver), true).flatMapConcatIterable(Function.identity()).flatMapMerge(srvEvent -> {
                this.assertInEventloop();
                if (ServiceDiscovererEvent.Status.AVAILABLE.equals((Object)srvEvent.status())) {
                    return Publisher.defer(() -> {
                        ARecordPublisher aPublisher = new ARecordPublisher(((HostAndPort)srvEvent.address()).hostName(), discoveryObserver);
                        ARecordPublisher prevAPublisher = aRecordMap.putIfAbsent(((HostAndPort)srvEvent.address()).hostName(), aPublisher);
                        if (prevAPublisher != null) {
                            return DefaultDnsClient.newDuplicateSrv(serviceName, ((HostAndPort)srvEvent.address()).hostName());
                        }
                        Publisher<Collection<ServiceDiscovererEvent<InetAddress>>> returnPub = DefaultDnsClient.recoverWithInactiveEvents(aPublisher, false);
                        return this.srvFilterDuplicateEvents ? DefaultDnsClient.srvFilterDups(returnPub, availableAddresses, ((HostAndPort)srvEvent.address()).port()) : returnPub.map(events -> DnsClients.mapEventList(events, inetAddress -> new InetSocketAddress((InetAddress)inetAddress, ((HostAndPort)srvEvent.address()).port())));
                    }).retryWhen((i, cause) -> {
                        this.assertInEventloop();
                        return cause == SrvAddressRemovedException.DNS_SRV_ADDR_REMOVED || aRecordMap.remove(((HostAndPort)srvEvent.address()).hostName()) == null ? Completable.failed((Throwable)cause) : this.srvHostNameRepeater.apply(i);
                    }).onErrorComplete();
                }
                if (srvEvent instanceof SrvInactiveEvent) {
                    return Publisher.from((Object)((SrvInactiveEvent)srvEvent).aggregatedEvents);
                }
                ARecordPublisher aPublisher = (ARecordPublisher)((Object)((Object)((Object)aRecordMap.remove(((HostAndPort)srvEvent.address()).hostName()))));
                if (aPublisher != null) {
                    aPublisher.cancelAndFail0(SrvAddressRemovedException.DNS_SRV_ADDR_REMOVED);
                }
                return Publisher.empty();
            }, this.srvConcurrency).liftSync((PublisherOperator)(this.inactiveEventsOnError ? SrvInactiveCombinerOperator.EMIT : SrvInactiveCombinerOperator.NO_EMIT));
        });
    }

    public Completable onClose() {
        return this.asyncCloseable.onClose();
    }

    public Completable closeAsync() {
        return this.asyncCloseable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.asyncCloseable.closeAsyncGracefully();
    }

    private void closeAsync0() {
        this.assertInEventloop();
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.resolver.close();
        this.ttlCache.clear();
    }

    private void assertInEventloop() {
        assert (this.nettyIoExecutor.isCurrentThreadEventLoop());
    }

    private static Publisher<? extends Collection<ServiceDiscovererEvent<InetSocketAddress>>> srvFilterDups(Publisher<? extends Collection<ServiceDiscovererEvent<InetAddress>>> returnPub, Map<InetSocketAddress, Integer> availableAddresses, int port) {
        return returnPub.map(events -> {
            ArrayList<DefaultServiceDiscovererEvent> mappedEvents = new ArrayList<DefaultServiceDiscovererEvent>(events.size());
            for (ServiceDiscovererEvent event : events) {
                InetSocketAddress addr = new InetSocketAddress((InetAddress)event.address(), port);
                ServiceDiscovererEvent.Status status = event.status();
                Integer count = (Integer)availableAddresses.get(addr);
                if (ServiceDiscovererEvent.Status.AVAILABLE.equals((Object)status)) {
                    if (count == null) {
                        mappedEvents.add(new DefaultServiceDiscovererEvent((Object)addr, status));
                        availableAddresses.put(addr, 1);
                        continue;
                    }
                    availableAddresses.put(addr, count + 1);
                    continue;
                }
                if (count == null) {
                    throw new IllegalStateException("null count for: " + addr);
                }
                if (count == 1) {
                    mappedEvents.add(new DefaultServiceDiscovererEvent((Object)addr, status));
                    availableAddresses.remove(addr);
                    continue;
                }
                availableAddresses.put(addr, count - 1);
            }
            return mappedEvents;
        }).filter(events -> !events.isEmpty());
    }

    private static <T, A> Publisher<? extends Collection<ServiceDiscovererEvent<T>>> recoverWithInactiveEvents(AbstractDnsPublisher<T> pub, boolean generateAggregateEvent) {
        return pub.onErrorResume(cause -> {
            List events;
            AbstractDnsPublisher.AbstractDnsSubscription subscription = pub.subscription;
            if (subscription != null && !(events = subscription.generateInactiveEvent()).isEmpty()) {
                return (generateAggregateEvent ? Publisher.from(Collections.singletonList(new SrvInactiveEvent(subscription.missingRecordStatus())), (Object)events) : Publisher.from((Object)events)).concat(Publisher.failed((Throwable)cause));
            }
            return Publisher.failed((Throwable)cause);
        });
    }

    private static <T> Publisher<T> newDuplicateSrv(String serviceName, String resolvedAddress) {
        return Publisher.failed((Throwable)new IllegalStateException("Duplicate SRV entry for SRV name " + serviceName + " for address " + resolvedAddress));
    }

    private static ResolvedAddressTypes toNettyType(DnsResolverAddressTypes dnsResolverAddressTypes) {
        switch (dnsResolverAddressTypes) {
            case IPV4_ONLY: {
                return ResolvedAddressTypes.IPV4_ONLY;
            }
            case IPV6_ONLY: {
                return ResolvedAddressTypes.IPV6_ONLY;
            }
            case IPV6_PREFERRED: {
                return ResolvedAddressTypes.IPV6_PREFERRED;
            }
            case IPV4_PREFERRED: {
                return ResolvedAddressTypes.IPV4_PREFERRED;
            }
        }
        throw new Error();
    }

    private static io.netty.resolver.dns.DnsServerAddressStreamProvider toNettyType(DnsServerAddressStreamProvider provider) {
        return hostname -> new ServiceTalkToNettyDnsServerAddressStream(provider.nameServerAddressStream(hostname));
    }

    private static final class SrvAddressRemovedException
    extends RuntimeException {
        private static final long serialVersionUID = -4083873869084533456L;
        private static final SrvAddressRemovedException DNS_SRV_ADDR_REMOVED = (SrvAddressRemovedException)ThrowableUtils.unknownStackTrace((Throwable)new SrvAddressRemovedException(), DefaultDnsClient.class, (String)"dnsSrvQuery");

        private SrvAddressRemovedException() {
        }
    }

    private static final class ClosedDnsServiceDiscovererException
    extends ClosedChannelException
    implements RejectedSubscribeError {
        private static final long serialVersionUID = -8092675984257002148L;

        private ClosedDnsServiceDiscovererException() {
        }
    }

    private static final class ServiceTalkToNettyDnsServerAddressStream
    implements io.netty.resolver.dns.DnsServerAddressStream {
        private final DnsServerAddressStream stream;

        ServiceTalkToNettyDnsServerAddressStream(DnsServerAddressStream stream) {
            this.stream = stream;
        }

        public InetSocketAddress next() {
            return this.stream.next();
        }

        public int size() {
            return this.stream.size();
        }

        public io.netty.resolver.dns.DnsServerAddressStream duplicate() {
            return new ServiceTalkToNettyDnsServerAddressStream(this.stream.duplicate());
        }
    }

    private static final class SrvAggregateList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -6105010311426084245L;

        private SrvAggregateList() {
        }
    }

    private static final class SrvInactiveEvent<T, A>
    implements ServiceDiscovererEvent<T> {
        private final ServiceDiscovererEvent.Status missingRecordStatus;
        private final List<ServiceDiscovererEvent<A>> aggregatedEvents = new SrvAggregateList<ServiceDiscovererEvent<A>>();

        SrvInactiveEvent(ServiceDiscovererEvent.Status missingRecordStatus) {
            this.missingRecordStatus = missingRecordStatus;
        }

        public T address() {
            throw new IllegalStateException("address method should not be called when isAvailable is false!");
        }

        public ServiceDiscovererEvent.Status status() {
            return this.missingRecordStatus;
        }
    }

    private static final class SrvInactiveCombinerOperator
    implements PublisherOperator<Collection<ServiceDiscovererEvent<InetSocketAddress>>, Collection<ServiceDiscovererEvent<InetSocketAddress>>> {
        static final SrvInactiveCombinerOperator EMIT = new SrvInactiveCombinerOperator(true);
        static final SrvInactiveCombinerOperator NO_EMIT = new SrvInactiveCombinerOperator(false);
        private final boolean emitAggregatedEvents;

        private SrvInactiveCombinerOperator(boolean emitAggregatedEvents) {
            this.emitAggregatedEvents = emitAggregatedEvents;
        }

        public PublisherSource.Subscriber<? super Collection<ServiceDiscovererEvent<InetSocketAddress>>> apply(final PublisherSource.Subscriber<? super Collection<ServiceDiscovererEvent<InetSocketAddress>>> subscriber) {
            return new PublisherSource.Subscriber<Collection<ServiceDiscovererEvent<InetSocketAddress>>>(){
                @Nullable
                private List<ServiceDiscovererEvent<InetSocketAddress>> aggregatedEvents;
                @Nullable
                private PublisherSource.Subscription subscription;

                public void onSubscribe(PublisherSource.Subscription s) {
                    this.subscription = s;
                    subscriber.onSubscribe(s);
                }

                public void onNext(@Nullable Collection<ServiceDiscovererEvent<InetSocketAddress>> evts) {
                    assert (this.subscription != null);
                    if (this.aggregatedEvents != null) {
                        if (evts != null && emitAggregatedEvents) {
                            this.aggregatedEvents.addAll(evts);
                        }
                        this.subscription.request(1L);
                    } else if (evts instanceof SrvAggregateList) {
                        this.aggregatedEvents = (List)evts;
                        this.subscription.request(1L);
                    } else {
                        subscriber.onNext(evts);
                    }
                }

                public void onError(Throwable t) {
                    try {
                        if (this.aggregatedEvents != null && emitAggregatedEvents) {
                            subscriber.onNext(this.aggregatedEvents);
                        }
                    }
                    finally {
                        subscriber.onError(t);
                    }
                }

                public void onComplete() {
                    subscriber.onComplete();
                }
            };
        }
    }

    private abstract class AbstractDnsPublisher<T>
    extends SubscribablePublisher<List<ServiceDiscovererEvent<T>>> {
        protected final String name;
        @Nullable
        protected final DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver;
        @Nullable
        AbstractDnsSubscription subscription;

        AbstractDnsPublisher(@Nullable String name, DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver) {
            this.name = name;
            this.discoveryObserver = discoveryObserver;
        }

        protected abstract AbstractDnsSubscription newSubscription(PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<T>>> var1);

        protected final void handleSubscribe(PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<T>>> subscriber) {
            if (DefaultDnsClient.this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                this.handleSubscribe0(subscriber);
            } else {
                DefaultDnsClient.this.nettyIoExecutor.execute(() -> this.handleSubscribe0(subscriber));
            }
        }

        private void handleSubscribe0(PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<T>>> subscriber) {
            DefaultDnsClient.this.assertInEventloop();
            if (this.subscription != null) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new DuplicateSubscribeException((Object)this.subscription, subscriber));
            } else if (DefaultDnsClient.this.closed) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new ClosedDnsServiceDiscovererException());
            } else {
                this.subscription = this.newSubscription(subscriber);
                try {
                    subscriber.onSubscribe((PublisherSource.Subscription)this.subscription);
                }
                catch (Throwable cause) {
                    SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)cause);
                }
            }
        }

        final void cancelAndFail0(Throwable cause) {
            DefaultDnsClient.this.assertInEventloop();
            if (this.subscription != null) {
                this.subscription.cancelAndTerminate0(cause);
            } else {
                this.subscription = this.newSubscription((PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<T>>>)CancelImmediatelySubscriber.INSTANCE);
            }
        }

        abstract class AbstractDnsSubscription
        implements PublisherSource.Subscription {
            private final PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<T>>> subscriber;
            private long pendingRequests;
            private List<T> activeAddresses;
            private long resolveDoneNoScheduleTime;
            @Nullable
            private Cancellable cancellableForQuery;
            private long ttlNanos;

            AbstractDnsSubscription(PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<T>>> subscriber) {
                this.subscriber = subscriber;
                this.activeAddresses = Collections.emptyList();
                this.ttlNanos = -1L;
            }

            protected abstract Future<DnsAnswer<T>> doDnsQuery();

            protected abstract Comparator<T> comparator();

            protected final ServiceDiscovererEvent.Status missingRecordStatus() {
                return DefaultDnsClient.this.missingRecordStatus;
            }

            public final void request(long n) {
                if (DefaultDnsClient.this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                    this.request0(n);
                } else {
                    DefaultDnsClient.this.nettyIoExecutor.execute(() -> this.request0(n));
                }
            }

            public final void cancel() {
                if (DefaultDnsClient.this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                    this.cancel0();
                } else {
                    DefaultDnsClient.this.nettyIoExecutor.execute(this::cancel0);
                }
            }

            private void request0(long n) {
                DefaultDnsClient.this.assertInEventloop();
                if (!SubscriberUtils.isRequestNValid((long)n)) {
                    this.handleTerminalError0(SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                    return;
                }
                this.pendingRequests = FlowControlUtils.addWithOverflowProtection((long)this.pendingRequests, (long)n);
                if (this.cancellableForQuery == null) {
                    if (this.ttlNanos < 0L) {
                        this.doQuery0();
                    } else {
                        long durationNs = DefaultDnsClient.this.nettyIoExecutor.currentTime(TimeUnit.NANOSECONDS) - this.resolveDoneNoScheduleTime;
                        if (durationNs > this.ttlNanos) {
                            this.doQuery0();
                        } else {
                            this.scheduleQuery0(this.ttlNanos - durationNs);
                        }
                    }
                }
            }

            private void doQuery0() {
                DefaultDnsClient.this.assertInEventloop();
                if (DefaultDnsClient.this.closed) {
                    this.handleTerminalError0(new ClosedDnsServiceDiscovererException());
                } else {
                    DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver = this.newResolutionObserver();
                    LOGGER.trace("DnsClient {}, querying DNS for {}", (Object)DefaultDnsClient.this, (Object)AbstractDnsPublisher.this);
                    Future addressFuture = this.doDnsQuery();
                    this.cancellableForQuery = () -> addressFuture.cancel(true);
                    if (addressFuture.isDone()) {
                        this.handleResolveDone0(addressFuture, resolutionObserver);
                    } else {
                        addressFuture.addListener((GenericFutureListener)((FutureListener)f -> this.handleResolveDone0(f, resolutionObserver)));
                    }
                }
            }

            @Nullable
            private DnsServiceDiscovererObserver.DnsResolutionObserver newResolutionObserver() {
                DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver = AbstractDnsPublisher.this.discoveryObserver;
                if (discoveryObserver == null) {
                    return null;
                }
                try {
                    return discoveryObserver.onNewResolution(AbstractDnsPublisher.this.name);
                }
                catch (Throwable unexpected) {
                    LOGGER.warn("Unexpected exception from {} while reporting new DNS resolution for: {}", new Object[]{DefaultDnsClient.this.observer, AbstractDnsPublisher.this.name, unexpected});
                    return null;
                }
            }

            private void cancel0() {
                DefaultDnsClient.this.assertInEventloop();
                Cancellable oldCancellable = this.cancellableForQuery;
                this.cancellableForQuery = TERMINATED;
                if (oldCancellable != null) {
                    oldCancellable.cancel();
                }
            }

            private void cancelAndTerminate0(Throwable cause) {
                try {
                    this.cancel0();
                }
                finally {
                    SubscriberUtils.safeOnError(this.subscriber, (Throwable)cause);
                }
            }

            private void scheduleQuery0(long nanos) {
                DefaultDnsClient.this.assertInEventloop();
                LOGGER.trace("DnsClient {}, scheduling DNS query for {} after {} nanos.", new Object[]{DefaultDnsClient.this, AbstractDnsPublisher.this, nanos});
                this.cancellableForQuery = DefaultDnsClient.this.nettyIoExecutor.schedule(this::doQuery0, nanos, TimeUnit.NANOSECONDS);
            }

            private void handleResolveDone0(Future<DnsAnswer<T>> addressFuture, @Nullable DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver) {
                DefaultDnsClient.this.assertInEventloop();
                assert (this.pendingRequests > 0L);
                if (this.cancellableForQuery == TERMINATED) {
                    return;
                }
                Throwable cause = addressFuture.cause();
                if (cause != null) {
                    this.reportResolutionFailed(resolutionObserver, cause);
                    this.cancelAndTerminate0(cause);
                } else {
                    DnsAnswer dnsAnswer = (DnsAnswer)addressFuture.getNow();
                    List addresses = dnsAnswer.answer();
                    List events = ServiceDiscovererUtils.calculateDifference(this.activeAddresses, addresses, this.comparator(), resolutionObserver == null ? null : (nAvailable, nMissing) -> this.reportResolutionResult(resolutionObserver, dnsAnswer, nAvailable, nMissing), DefaultDnsClient.this.missingRecordStatus);
                    this.ttlNanos = dnsAnswer.ttlNanos();
                    if (events != null) {
                        this.activeAddresses = addresses;
                        if (--this.pendingRequests > 0L) {
                            this.scheduleQuery0(this.ttlNanos);
                        } else {
                            this.resolveDoneNoScheduleTime = DefaultDnsClient.this.nettyIoExecutor.currentTime(TimeUnit.NANOSECONDS);
                            this.cancellableForQuery = null;
                        }
                        try {
                            LOGGER.debug("DnsClient {}, sending events for address: {} (size {}) {}.", new Object[]{DefaultDnsClient.this, AbstractDnsPublisher.this, events.size(), events});
                            this.subscriber.onNext(events);
                        }
                        catch (Throwable error) {
                            this.handleTerminalError0(error);
                        }
                    } else {
                        LOGGER.trace("DnsClient {}, resolution done but no changes for address: {} (size {}) {}.", new Object[]{DefaultDnsClient.this, AbstractDnsPublisher.this, this.activeAddresses.size(), this.activeAddresses});
                        this.scheduleQuery0(this.ttlNanos);
                    }
                }
            }

            private void reportResolutionFailed(@Nullable DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver, Throwable cause) {
                if (resolutionObserver == null) {
                    return;
                }
                try {
                    resolutionObserver.resolutionFailed(cause);
                }
                catch (Throwable unexpected) {
                    unexpected.addSuppressed(cause);
                    LOGGER.warn("Unexpected exception from {} while reporting DNS resolution failure", (Object)resolutionObserver, (Object)unexpected);
                }
            }

            private void reportResolutionResult(DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver, DnsAnswer<T> dnsAnswer, int nAvailable, int nMissing) {
                DefaultResolutionResult result = new DefaultResolutionResult(dnsAnswer.answer().size(), (int)TimeUnit.NANOSECONDS.toSeconds(dnsAnswer.ttlNanos()), nAvailable, nMissing);
                try {
                    resolutionObserver.resolutionCompleted(result);
                }
                catch (Throwable unexpected) {
                    LOGGER.warn("Unexpected exception from {} while reporting DNS resolution result {}", new Object[]{resolutionObserver, result, unexpected});
                }
            }

            private void handleTerminalError0(Throwable cause) {
                DefaultDnsClient.this.assertInEventloop();
                if (this.cancellableForQuery != TERMINATED) {
                    this.cancelAndTerminate0(cause);
                }
            }

            private List<ServiceDiscovererEvent<T>> generateInactiveEvent() {
                ArrayList events = new ArrayList(this.activeAddresses.size());
                if (this.activeAddresses instanceof RandomAccess) {
                    for (int i = 0; i < this.activeAddresses.size(); ++i) {
                        events.add((ServiceDiscovererEvent)new DefaultServiceDiscovererEvent(this.activeAddresses.get(i), DefaultDnsClient.this.missingRecordStatus));
                    }
                } else {
                    for (Object address : this.activeAddresses) {
                        events.add((ServiceDiscovererEvent)new DefaultServiceDiscovererEvent(address, DefaultDnsClient.this.missingRecordStatus));
                    }
                }
                this.activeAddresses = Collections.emptyList();
                return events;
            }
        }
    }

    private static final class DnsAnswer<T> {
        private final List<T> answer;
        private final long ttlNanos;

        DnsAnswer(List<T> answer, long ttlNanos) {
            this.answer = answer;
            this.ttlNanos = ttlNanos;
        }

        List<T> answer() {
            return this.answer;
        }

        long ttlNanos() {
            return this.ttlNanos;
        }
    }

    private class ARecordPublisher
    extends AbstractDnsPublisher<InetAddress> {
        ARecordPublisher(@Nullable String inetHost, DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver) {
            super(inetHost, discoveryObserver);
        }

        public String toString() {
            return "A* lookups for " + this.name;
        }

        @Override
        protected AbstractDnsPublisher.AbstractDnsSubscription newSubscription(PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<InetAddress>>> subscriber) {
            return new AbstractDnsPublisher.AbstractDnsSubscription(subscriber){

                protected Future<DnsAnswer<InetAddress>> doDnsQuery() {
                    DefaultDnsClient.this.ttlCache.prepareForResolution(ARecordPublisher.this.name);
                    Promise dnsAnswerPromise = ImmediateEventExecutor.INSTANCE.newPromise();
                    DefaultDnsClient.this.resolver.resolveAll(ARecordPublisher.this.name).addListener(completedFuture -> {
                        Throwable cause = completedFuture.cause();
                        if (cause != null) {
                            dnsAnswerPromise.setFailure(cause);
                        } else {
                            DnsAnswer dnsAnswer;
                            try {
                                List addresses = (List)completedFuture.getNow();
                                dnsAnswer = new DnsAnswer(addresses, TimeUnit.SECONDS.toNanos(DefaultDnsClient.this.ttlCache.minTtl(ARecordPublisher.this.name)));
                            }
                            catch (Throwable cause2) {
                                dnsAnswerPromise.setFailure(cause2);
                                return;
                            }
                            dnsAnswerPromise.setSuccess(dnsAnswer);
                        }
                    });
                    return dnsAnswerPromise;
                }

                protected Comparator<InetAddress> comparator() {
                    return INET_ADDRESS_COMPARATOR;
                }
            };
        }
    }

    private final class SrvRecordPublisher
    extends AbstractDnsPublisher<HostAndPort> {
        private SrvRecordPublisher(@Nullable String serviceName, DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver) {
            super(serviceName, discoveryObserver);
        }

        public String toString() {
            return "SRV lookups for " + this.name;
        }

        @Override
        protected AbstractDnsPublisher.AbstractDnsSubscription newSubscription(PublisherSource.Subscriber<? super List<ServiceDiscovererEvent<HostAndPort>>> subscriber) {
            return new AbstractDnsPublisher.AbstractDnsSubscription(subscriber){

                protected Future<DnsAnswer<HostAndPort>> doDnsQuery() {
                    Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
                    DefaultDnsClient.this.resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion(SrvRecordPublisher.this.name, DnsRecordType.SRV)).addListener(completedFuture -> {
                        Throwable cause = completedFuture.cause();
                        if (cause != null) {
                            promise.setFailure(cause);
                        } else {
                            DnsAnswer dnsAnswer;
                            long minTTLSeconds = Long.MAX_VALUE;
                            List toRelease = null;
                            try {
                                List dnsRecords = (List)completedFuture.getNow();
                                toRelease = dnsRecords;
                                ArrayList<HostAndPort> hostAndPorts = new ArrayList<HostAndPort>(dnsRecords.size());
                                Iterator iterator = dnsRecords.iterator();
                                while (iterator.hasNext()) {
                                    DnsRecord dnsRecord = (DnsRecord)iterator.next();
                                    if (!DnsRecordType.SRV.equals((Object)dnsRecord.type()) || !(dnsRecord instanceof DnsRawRecord)) {
                                        throw new IllegalArgumentException("Unsupported DNS record type for SRV query: " + dnsRecord);
                                    }
                                    if (dnsRecord.timeToLive() < minTTLSeconds) {
                                        minTTLSeconds = dnsRecord.timeToLive();
                                    }
                                    ByteBuf content = ((DnsRawRecord)dnsRecord).content();
                                    content.skipBytes(4);
                                    int port = content.readUnsignedShort();
                                    hostAndPorts.add(HostAndPort.of((String)DefaultDnsRecordDecoder.decodeName((ByteBuf)content), (int)port));
                                }
                                dnsAnswer = new DnsAnswer(hostAndPorts, TimeUnit.SECONDS.toNanos(minTTLSeconds));
                            }
                            catch (Throwable cause2) {
                                promise.setFailure(cause2);
                                return;
                            }
                            finally {
                                if (toRelease != null) {
                                    for (DnsRecord dnsRecord : toRelease) {
                                        ReferenceCountUtil.release((Object)dnsRecord);
                                    }
                                }
                            }
                            promise.setSuccess(dnsAnswer);
                        }
                    });
                    return promise;
                }

                protected Comparator<HostAndPort> comparator() {
                    return HOST_AND_PORT_COMPARATOR;
                }
            };
        }
    }
}

