/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsNameResolverBuilder;

public enum DnsResolverAddressTypes {
    IPV4_ONLY,
    IPV6_ONLY,
    IPV4_PREFERRED,
    IPV6_PREFERRED,
    IPV4_PREFERRED_RETURN_ALL,
    IPV6_PREFERRED_RETURN_ALL;

    private static final String A_AAAA_STRING;
    private static final String AAAA_A_STRING;

    static DnsResolverAddressTypes systemDefault() {
        return DnsResolverAddressTypes.fromNettyType(DnsNameResolverBuilder.computeResolvedAddressTypes((InternetProtocolFamily[])new InternetProtocolFamily[0]));
    }

    private static DnsResolverAddressTypes fromNettyType(ResolvedAddressTypes resolvedAddressType) {
        switch (resolvedAddressType) {
            case IPV4_ONLY: {
                return IPV4_ONLY;
            }
            case IPV6_ONLY: {
                return IPV6_ONLY;
            }
            case IPV4_PREFERRED: {
                return IPV4_PREFERRED;
            }
            case IPV6_PREFERRED: {
                return IPV6_PREFERRED;
            }
        }
        throw new IllegalArgumentException("Unknown value for " + ResolvedAddressTypes.class.getName() + ": " + resolvedAddressType);
    }

    static ResolvedAddressTypes toNettyType(DnsResolverAddressTypes dnsResolverAddressType) {
        switch (dnsResolverAddressType) {
            case IPV4_ONLY: {
                return ResolvedAddressTypes.IPV4_ONLY;
            }
            case IPV6_ONLY: {
                return ResolvedAddressTypes.IPV6_ONLY;
            }
            case IPV4_PREFERRED: 
            case IPV4_PREFERRED_RETURN_ALL: {
                return ResolvedAddressTypes.IPV4_PREFERRED;
            }
            case IPV6_PREFERRED: 
            case IPV6_PREFERRED_RETURN_ALL: {
                return ResolvedAddressTypes.IPV6_PREFERRED;
            }
        }
        throw new IllegalArgumentException("Unknown value for " + DnsResolverAddressTypes.class.getName() + ": " + (Object)((Object)dnsResolverAddressType));
    }

    static InternetProtocolFamily preferredAddressType(ResolvedAddressTypes resolvedAddressTypes) {
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: 
            case IPV4_PREFERRED: {
                return InternetProtocolFamily.IPv4;
            }
            case IPV6_ONLY: 
            case IPV6_PREFERRED: {
                return InternetProtocolFamily.IPv6;
            }
        }
        throw new IllegalArgumentException("Unknown value for " + ResolvedAddressTypes.class.getName() + ": " + resolvedAddressTypes);
    }

    static String toRecordTypeNames(DnsResolverAddressTypes dnsResolverAddressType) {
        switch (dnsResolverAddressType) {
            case IPV4_ONLY: {
                return DnsRecordType.A.toString();
            }
            case IPV6_ONLY: {
                return DnsRecordType.AAAA.toString();
            }
            case IPV4_PREFERRED: 
            case IPV4_PREFERRED_RETURN_ALL: {
                return A_AAAA_STRING;
            }
            case IPV6_PREFERRED: 
            case IPV6_PREFERRED_RETURN_ALL: {
                return AAAA_A_STRING;
            }
        }
        throw new IllegalArgumentException("Unknown value for " + DnsResolverAddressTypes.class.getName() + ": " + (Object)((Object)dnsResolverAddressType));
    }

    static {
        A_AAAA_STRING = DnsRecordType.A + ", " + DnsRecordType.AAAA;
        AAAA_A_STRING = DnsRecordType.AAAA + ", " + DnsRecordType.A;
    }
}

