/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.dns.discovery.netty.DefaultDnsClient;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.dns.discovery.netty.DnsClientFilterFactory;
import io.servicetalk.dns.discovery.netty.DnsClients;
import io.servicetalk.dns.discovery.netty.DnsResolverAddressTypes;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererBuilder;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererObserver;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import io.servicetalk.utils.internal.DurationUtils;
import io.servicetalk.utils.internal.NumberUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class DefaultDnsServiceDiscovererBuilder
implements DnsServiceDiscovererBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDnsServiceDiscovererBuilder.class);
    @Deprecated
    private static final String DATAGRAM_CHANNEL_STRATEGY_PROPERTY = "io.servicetalk.dns.discovery.netty.experimental.datagramChannelStrategy";
    @Deprecated
    private static final String TCP_FALLBACK_ON_TIMEOUT_PROPERTY = "io.servicetalk.dns.discovery.netty.experimental.tcpFallbackOnTimeout";
    @Deprecated
    private static final String SKIP_BINDING_PROPERTY = "io.servicetalk.dns.discovery.netty.skipBinding";
    @Deprecated
    private static final String NX_DOMAIN_INVALIDATES_PROPERTY = "io.servicetalk.dns.discovery.nxdomain.invalidation";
    private static final String DEFAULT_DATAGRAM_CHANNEL_STRATEGY = System.getProperty("io.servicetalk.dns.discovery.netty.experimental.datagramChannelStrategy", "ChannelPerResolver");
    private static final boolean DEFAULT_TCP_FALLBACK_ON_TIMEOUT = Boolean.getBoolean("io.servicetalk.dns.discovery.netty.experimental.tcpFallbackOnTimeout");
    private static final boolean DEFAULT_NX_DOMAIN_INVALIDATES = Boolean.getBoolean("io.servicetalk.dns.discovery.nxdomain.invalidation");
    @Nullable
    private static final SocketAddress DEFAULT_LOCAL_ADDRESS = Boolean.getBoolean("io.servicetalk.dns.discovery.netty.skipBinding") ? null : new InetSocketAddress(0);
    private static final DnsResolverAddressTypes DEFAULT_DNS_RESOLVER_ADDRESS_TYPES = DnsResolverAddressTypes.systemDefault();
    static final int DEFAULT_CONSOLIDATE_CACHE_SIZE = 1024;
    private static final int DEFAULT_MIN_TTL_POLL_SECONDS = 10;
    private static final int DEFAULT_MAX_TTL_POLL_SECONDS = (int)TimeUnit.MINUTES.toSeconds(5L);
    private static final int DEFAULT_MIN_TTL_CACHE_SECONDS = 0;
    private static final int DEFAULT_MAX_TTL_CACHE_SECONDS = 30;
    private static final int DEFAULT_TTL_POLL_JITTER_SECONDS = 4;
    private static final String NEGATIVE_TTL_CACHE_SECONDS_PROPERTY = "networkaddress.cache.negative.ttl";
    private static final int DEFAULT_NEGATIVE_TTL_CACHE_SECONDS;
    private static final ServiceDiscovererEvent.Status DEFAULT_MISSING_RECOREDS_STATUS;
    private final String id;
    @Nullable
    private SocketAddress localAddress = DEFAULT_LOCAL_ADDRESS;
    @Nullable
    private DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private DnsResolverAddressTypes dnsResolverAddressTypes = DEFAULT_DNS_RESOLVER_ADDRESS_TYPES;
    @Nullable
    private Integer maxUdpPayloadSize;
    @Nullable
    private Integer ndots;
    @Nullable
    private Boolean optResourceEnabled;
    @Nullable
    private IoExecutor ioExecutor;
    @Nullable
    private Duration queryTimeout;
    @Nullable
    private Duration resolutionTimeout;
    private int consolidateCacheSize = 1024;
    private int minTTLSeconds = 10;
    private int maxTTLSeconds = DEFAULT_MAX_TTL_POLL_SECONDS;
    private int minTTLCacheSeconds = 0;
    private int maxTTLCacheSeconds = 30;
    private int negativeTTLCacheSeconds = DEFAULT_NEGATIVE_TTL_CACHE_SECONDS;
    private Duration ttlJitter = Duration.ofSeconds(4L);
    private int srvConcurrency = 2048;
    private boolean completeOncePreferredResolved = true;
    private boolean srvFilterDuplicateEvents;
    private Duration srvHostNameRepeatInitialDelay = Duration.ofSeconds(10L);
    private Duration srvHostNameRepeatJitter = Duration.ofSeconds(5L);
    @Nullable
    private DnsClientFilterFactory filterFactory;
    @Nullable
    private DnsServiceDiscovererObserver observer;
    private ServiceDiscovererEvent.Status missingRecordStatus = DEFAULT_MISSING_RECOREDS_STATUS;
    private boolean nxInvalidation = DEFAULT_NX_DOMAIN_INVALIDATES;

    @Deprecated
    public DefaultDnsServiceDiscovererBuilder() {
        this("undefined");
    }

    DefaultDnsServiceDiscovererBuilder(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id can not be empty");
        }
        this.id = id;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder consolidateCacheSize(int consolidateCacheSize) {
        this.consolidateCacheSize = NumberUtils.ensureNonNegative((int)consolidateCacheSize, (String)"consolidateCacheSize");
        return this;
    }

    @Deprecated
    public DefaultDnsServiceDiscovererBuilder minTTL(int minTTLSeconds) {
        this.minTTLSeconds = NumberUtils.ensurePositive((int)minTTLSeconds, (String)"minTTLSeconds");
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ttl(int minSeconds, int maxSeconds) {
        this.ttl(minSeconds, maxSeconds, Math.min(minSeconds, 0), Math.min(maxSeconds, 30));
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ttl(int minSeconds, int maxSeconds, int minCacheSeconds, int maxCacheSeconds) {
        this.ttl(minSeconds, maxSeconds, minCacheSeconds, maxCacheSeconds, DEFAULT_NEGATIVE_TTL_CACHE_SECONDS);
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ttl(int minSeconds, int maxSeconds, int minCacheSeconds, int maxCacheSeconds, int negativeTTLCacheSeconds) {
        if (minSeconds <= 0 || maxSeconds < minSeconds) {
            throw new IllegalArgumentException("minSeconds: " + minSeconds + ", maxSeconds: " + maxSeconds + " (expected: 0 < minSeconds <= maxSeconds)");
        }
        if (minCacheSeconds < 0 || maxCacheSeconds < minCacheSeconds) {
            throw new IllegalArgumentException("minCacheSeconds: " + minCacheSeconds + ", maxCacheSeconds: " + maxCacheSeconds + " (expected: 0 <= minCacheSeconds <= maxCacheSeconds)");
        }
        if (minCacheSeconds > minSeconds || maxCacheSeconds > maxSeconds) {
            throw new IllegalArgumentException("minCacheSeconds: " + minCacheSeconds + ", maxCacheSeconds: " + maxCacheSeconds + " (expected: 0 <= minCacheSeconds <= minSeconds(" + minSeconds + ") <= maxCacheSeconds <= maxSeconds(" + maxSeconds + "))");
        }
        this.negativeTTLCacheSeconds = NumberUtils.ensureNonNegative((int)negativeTTLCacheSeconds, (String)"negativeTTLCacheSeconds");
        this.minTTLSeconds = minSeconds;
        this.maxTTLSeconds = maxSeconds;
        this.minTTLCacheSeconds = minCacheSeconds;
        this.maxTTLCacheSeconds = maxCacheSeconds;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ttlJitter(Duration ttlJitter) {
        DurationUtils.ensureNonNegative((Duration)ttlJitter, (String)"jitter");
        this.ttlJitter = ttlJitter;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder localAddress(@Nullable SocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder dnsServerAddressStreamProvider(@Nullable DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder maxUdpPayloadSize(int maxUdpPayloadSize) {
        this.maxUdpPayloadSize = NumberUtils.ensurePositive((int)maxUdpPayloadSize, (String)"maxUdpPayloadSize");
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder queryTimeout(@Nullable Duration queryTimeout) {
        this.queryTimeout = queryTimeout == null ? null : DurationUtils.ensureNonNegative((Duration)queryTimeout, (String)"queryTimeout");
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder resolutionTimeout(@Nullable Duration resolutionTimeout) {
        this.resolutionTimeout = resolutionTimeout == null ? null : DurationUtils.ensureNonNegative((Duration)resolutionTimeout, (String)"resolutionTimeout");
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder dnsResolverAddressTypes(@Nullable DnsResolverAddressTypes dnsResolverAddressTypes) {
        this.dnsResolverAddressTypes = dnsResolverAddressTypes != null ? dnsResolverAddressTypes : DEFAULT_DNS_RESOLVER_ADDRESS_TYPES;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder ioExecutor(IoExecutor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder observer(DnsServiceDiscovererObserver observer) {
        this.observer = Objects.requireNonNull(observer);
        return this;
    }

    @Override
    public DefaultDnsServiceDiscovererBuilder missingRecordStatus(ServiceDiscovererEvent.Status status) {
        if (ServiceDiscovererEvent.Status.AVAILABLE.equals((Object)status)) {
            throw new IllegalArgumentException(ServiceDiscovererEvent.Status.AVAILABLE + " status can not be used as missing records' status.");
        }
        this.missingRecordStatus = Objects.requireNonNull(status);
        return this;
    }

    DefaultDnsServiceDiscovererBuilder nxInvalidates(boolean nxInvalidation) {
        this.nxInvalidation = nxInvalidation;
        return this;
    }

    @Override
    public ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildSrvDiscoverer() {
        return DnsClients.asSrvDiscoverer(this.build());
    }

    @Override
    public ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildARecordDiscoverer() {
        return DnsClients.asHostAndPortDiscoverer(this.build());
    }

    DefaultDnsServiceDiscovererBuilder srvConcurrency(int srvConcurrency) {
        this.srvConcurrency = NumberUtils.ensurePositive((int)srvConcurrency, (String)"srvConcurrency");
        return this;
    }

    DefaultDnsServiceDiscovererBuilder completeOncePreferredResolved(boolean completeOncePreferredResolved) {
        this.completeOncePreferredResolved = completeOncePreferredResolved;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvHostNameRepeatDelay(Duration initialDelay, Duration jitter) {
        this.srvHostNameRepeatInitialDelay = DurationUtils.ensurePositive((Duration)initialDelay, (String)"srvHostNameRepeatInitialDelay");
        this.srvHostNameRepeatJitter = DurationUtils.ensureNonNegative((Duration)jitter, (String)"srvHostNameRepeatJitter");
        if (this.srvHostNameRepeatJitter.toNanos() >= this.srvHostNameRepeatInitialDelay.toNanos()) {
            throw new IllegalArgumentException("The jitter value should be less than the initial delay.");
        }
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvFilterDuplicateEvents(boolean srvFilterDuplicateEvents) {
        this.srvFilterDuplicateEvents = srvFilterDuplicateEvents;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder appendFilter(DnsClientFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.filterFactory = DefaultDnsServiceDiscovererBuilder.appendFilter(this.filterFactory, factory);
        return this;
    }

    private static DnsClientFilterFactory appendFilter(@Nullable DnsClientFilterFactory current, DnsClientFilterFactory next) {
        return current == null ? next : dnsClient -> current.create(next.create(dnsClient));
    }

    DnsClient build() {
        DefaultDnsClient rawClient = new DefaultDnsClient(this.id, this.ioExecutor == null ? GlobalExecutionContext.globalExecutionContext().ioExecutor() : this.ioExecutor, this.consolidateCacheSize, this.minTTLSeconds, this.maxTTLSeconds, this.minTTLCacheSeconds, this.maxTTLCacheSeconds, this.negativeTTLCacheSeconds, this.ttlJitter.toNanos(), this.srvConcurrency, this.completeOncePreferredResolved, this.srvFilterDuplicateEvents, this.srvHostNameRepeatInitialDelay, this.srvHostNameRepeatJitter, this.maxUdpPayloadSize, this.ndots, this.optResourceEnabled, this.queryTimeout, this.resolutionTimeout, this.dnsResolverAddressTypes, this.localAddress, this.dnsServerAddressStreamProvider, this.observer, this.missingRecordStatus, this.nxInvalidation, DEFAULT_TCP_FALLBACK_ON_TIMEOUT, DEFAULT_DATAGRAM_CHANNEL_STRATEGY);
        return this.filterFactory == null ? rawClient : this.filterFactory.create(rawClient);
    }

    @Nullable
    private static int parseProperty(String name, int defaultValue) {
        String value = System.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Can not parse the value of -D{}={}, using {} as a default", new Object[]{name, value, defaultValue, e});
            return defaultValue;
        }
    }

    static {
        DEFAULT_MISSING_RECOREDS_STATUS = ServiceDiscovererEvent.Status.EXPIRED;
        int negativeCacheTtlValue = DefaultDnsServiceDiscovererBuilder.parseProperty(NEGATIVE_TTL_CACHE_SECONDS_PROPERTY, 0);
        int n = DEFAULT_NEGATIVE_TTL_CACHE_SECONDS = negativeCacheTtlValue < 0 ? Integer.MAX_VALUE : negativeCacheTtlValue;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("-D{}: {}", (Object)SKIP_BINDING_PROPERTY, (Object)Boolean.getBoolean(SKIP_BINDING_PROPERTY));
            LOGGER.debug("Default local address to bind to: {}", (Object)DEFAULT_LOCAL_ADDRESS);
            LOGGER.debug("Default DnsResolverAddressTypes: {}", (Object)DEFAULT_DNS_RESOLVER_ADDRESS_TYPES);
            LOGGER.debug("Default consolidate cache size: {}", (Object)1024);
            LOGGER.debug("Default TTL poll boundaries in seconds: [{}, {}]", (Object)10, (Object)DEFAULT_MAX_TTL_POLL_SECONDS);
            LOGGER.debug("Default TTL poll jitter seconds: {}", (Object)4);
            LOGGER.debug("Default TTL cache boundaries in seconds: [{}, {}]", (Object)0, (Object)30);
            LOGGER.debug("-D{}: {}", (Object)NEGATIVE_TTL_CACHE_SECONDS_PROPERTY, (Object)negativeCacheTtlValue);
            LOGGER.debug("Default negative TTL cache in seconds: {}", (Object)DEFAULT_NEGATIVE_TTL_CACHE_SECONDS);
            LOGGER.debug("Default missing records status: {}", (Object)DEFAULT_MISSING_RECOREDS_STATUS);
            LOGGER.debug("-D{}: {}", (Object)NX_DOMAIN_INVALIDATES_PROPERTY, (Object)DEFAULT_NX_DOMAIN_INVALIDATES);
            LOGGER.debug("-D{}: {}", (Object)TCP_FALLBACK_ON_TIMEOUT_PROPERTY, (Object)DEFAULT_TCP_FALLBACK_ON_TIMEOUT);
            LOGGER.debug("-D{}: {}", (Object)DATAGRAM_CHANNEL_STRATEGY_PROPERTY, (Object)DEFAULT_DATAGRAM_CHANNEL_STRATEGY);
        }
    }
}

