/*
 * Copyright © 2024 Apple Inc. and the ServiceTalk project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.concurrent.internal.ThrowableUtils;

import java.net.UnknownHostException;

final class DnsNameResolverTimeoutException extends UnknownHostException {
    private static final long serialVersionUID = 3089160074512305891L;

    private DnsNameResolverTimeoutException(final String name, final String recordType, final long timeoutMs) {
        super("Resolution for '" + name + "' [" + recordType + "] timed out after " + timeoutMs + " milliseconds");
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    static DnsNameResolverTimeoutException newInstance(final String name, final long timeoutMs, final String recordType,
                                                       final Class<?> clazz, final String method) {
        return ThrowableUtils.unknownStackTrace(new DnsNameResolverTimeoutException(name, recordType, timeoutMs),
                clazz, method);
    }
}
