/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.dns.discovery.netty.DefaultDnsServiceDiscovererBuilder;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererBuilder;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererBuilderProvider;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DnsServiceDiscoverers {
    private static final Logger LOGGER = LoggerFactory.getLogger(DnsServiceDiscoverers.class);
    private static final List<DnsServiceDiscovererBuilderProvider> PROVIDERS;
    private static final String GLOBAL_A_ID = "global-a";
    private static final String GLOBAL_SRV_ID = "global-srv";

    private DnsServiceDiscoverers() {
    }

    private static DnsServiceDiscovererBuilder applyProviders(String id, DnsServiceDiscovererBuilder builder) {
        for (DnsServiceDiscovererBuilderProvider provider : PROVIDERS) {
            builder = provider.newBuilder(id, builder);
        }
        return builder;
    }

    public static DnsServiceDiscovererBuilder builder(String id) {
        LOGGER.debug("Created a new {} for id={}", (Object)DnsServiceDiscovererBuilder.class.getSimpleName(), (Object)id);
        return DnsServiceDiscoverers.applyProviders(id, new DefaultDnsServiceDiscovererBuilder(id));
    }

    public static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalARecordsDnsServiceDiscoverer() {
        return ARecordsDnsServiceDiscoverer.INSTANCE;
    }

    public static ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalSrvRecordsDnsServiceDiscoverer() {
        return SrvRecordsDnsServiceDiscoverer.INSTANCE;
    }

    static {
        ClassLoader classLoader = DnsServiceDiscoverers.class.getClassLoader();
        PROVIDERS = ServiceLoaderUtils.loadProviders(DnsServiceDiscovererBuilderProvider.class, (ClassLoader)classLoader, (Logger)LOGGER);
    }

    private static final class SrvRecordsDnsServiceDiscoverer {
        static final ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> INSTANCE = DnsServiceDiscoverers.builder("global-srv").buildSrvDiscoverer();

        private SrvRecordsDnsServiceDiscoverer() {
        }

        static {
            LOGGER.debug("Initialized {}: {}", (Object)SrvRecordsDnsServiceDiscoverer.class.getSimpleName(), INSTANCE);
        }
    }

    private static final class ARecordsDnsServiceDiscoverer {
        static final ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> INSTANCE = DnsServiceDiscoverers.builder("global-a").buildARecordDiscoverer();

        private ARecordsDnsServiceDiscoverer() {
        }

        static {
            LOGGER.debug("Initialized {}: {}", (Object)ARecordsDnsServiceDiscoverer.class.getSimpleName(), INSTANCE);
        }
    }
}

