/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsNameResolverChannelStrategy;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DnsNameResolverBuilderUtils {
    private static final Logger LOGGER;
    private static final String NETTY_VERSION;
    private static final String DEFAULT_DATAGRAM_CHANNEL_STRATEGY = "ChannelPerResolver";
    @Nullable
    private static final MethodHandle CONSOLIDATE_CACHE_SIZE;
    @Nullable
    private static final MethodHandle TCP_FALLBACK_ON_TIMEOUT;
    @Nullable
    private static final MethodHandle DATAGRAM_CHANNEL_STRATEGY;

    private DnsNameResolverBuilderUtils() {
    }

    private static DnsNameResolverBuilder consolidateCacheSize(MethodHandle consolidateCacheSize, DnsNameResolverBuilder builder, int maxNumConsolidation) {
        try {
            return consolidateCacheSize.invokeExact(builder, maxNumConsolidation);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException((Throwable)t);
            return builder;
        }
    }

    private static DnsNameResolverBuilder enableTcpFallback(MethodHandle tcpFallbackOnTimeout, DnsNameResolverBuilder builder, Class<? extends SocketChannel> socketChannelClass, boolean retryOnTimeout) {
        try {
            return tcpFallbackOnTimeout.invokeExact(builder, socketChannelClass, retryOnTimeout);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException((Throwable)t);
            return builder;
        }
    }

    private static DnsNameResolverBuilder datagramChannelStrategy(MethodHandle datagramChannelStrategy, DnsNameResolverBuilder builder, String strategy) {
        try {
            return datagramChannelStrategy.invokeExact(builder, LazyHolder.toNettyStrategy(strategy));
        }
        catch (Throwable t) {
            ThrowableUtils.throwException((Throwable)t);
            return builder;
        }
    }

    static void consolidateCacheSize(String id, DnsNameResolverBuilder builder, int maxNumConsolidation) {
        if (CONSOLIDATE_CACHE_SIZE == null) {
            if (maxNumConsolidation != 1024) {
                LOGGER.warn("consolidateCacheSize({}) can not be applied for a new DNS ServiceDiscoverer '{}' because io.netty.resolver.dns.DnsNameResolverBuilder#consolidateCacheSize(int) method is not available in Netty {}, expected Netty version is 4.1.88.Final or later.", new Object[]{maxNumConsolidation, id, NETTY_VERSION});
            }
            return;
        }
        DnsNameResolverBuilderUtils.consolidateCacheSize(CONSOLIDATE_CACHE_SIZE, builder, maxNumConsolidation);
    }

    static void enableTcpFallback(String id, DnsNameResolverBuilder builder, Class<? extends SocketChannel> socketChannelClass, boolean retryOnTimeout) {
        if (TCP_FALLBACK_ON_TIMEOUT == null) {
            if (retryOnTimeout) {
                LOGGER.warn("tcpFallbackOnTimeout({}) can not be applied for a new DNS ServiceDiscoverer '{}' because io.netty.resolver.dns.DnsNameResolverBuilder#socketChannelType(Class, boolean) method is not available in Netty {}, expected Netty version is 4.1.105.Final or later.", new Object[]{retryOnTimeout, id, NETTY_VERSION});
            }
            builder.socketChannelType(socketChannelClass);
            return;
        }
        DnsNameResolverBuilderUtils.enableTcpFallback(TCP_FALLBACK_ON_TIMEOUT, builder, socketChannelClass, retryOnTimeout);
    }

    static void datagramChannelStrategy(String id, DnsNameResolverBuilder builder, String datagramChannelStrategy) {
        if (DATAGRAM_CHANNEL_STRATEGY == null) {
            if (!DEFAULT_DATAGRAM_CHANNEL_STRATEGY.equals(datagramChannelStrategy)) {
                LOGGER.warn("datagramChannelStrategy({}) can not be applied for a new DNS ServiceDiscoverer '{}' because io.netty.resolver.dns.DnsNameResolverBuilder#datagramChannelStrategy(...) method is not available in Netty {}, expected Netty version is 4.1.114.Final or later.", new Object[]{datagramChannelStrategy, id, NETTY_VERSION});
            }
            return;
        }
        DnsNameResolverBuilderUtils.datagramChannelStrategy(DATAGRAM_CHANNEL_STRATEGY, builder, datagramChannelStrategy);
    }

    static {
        MethodHandle datagramChannelStrategy;
        MethodHandle tcpFallbackOnTimeout;
        MethodHandle consolidateCacheSize;
        LOGGER = LoggerFactory.getLogger(DnsNameResolverBuilderUtils.class);
        NETTY_VERSION = DnsNameResolverBuilder.class.getPackage().getImplementationVersion();
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder();
        try {
            consolidateCacheSize = MethodHandles.publicLookup().findVirtual(DnsNameResolverBuilder.class, "consolidateCacheSize", MethodType.methodType(DnsNameResolverBuilder.class, Integer.TYPE));
            DnsNameResolverBuilderUtils.consolidateCacheSize(consolidateCacheSize, builder, 1);
        }
        catch (Throwable cause) {
            LOGGER.debug("DnsNameResolverBuilder#consolidateCacheSize(int) is available only starting from Netty 4.1.88.Final. Detected Netty version: {}", (Object)NETTY_VERSION, (Object)cause);
            consolidateCacheSize = null;
        }
        CONSOLIDATE_CACHE_SIZE = consolidateCacheSize;
        try {
            tcpFallbackOnTimeout = MethodHandles.publicLookup().findVirtual(DnsNameResolverBuilder.class, "socketChannelType", MethodType.methodType(DnsNameResolverBuilder.class, Class.class, Boolean.TYPE));
            DnsNameResolverBuilderUtils.enableTcpFallback(tcpFallbackOnTimeout, builder, NioSocketChannel.class, true);
        }
        catch (Throwable cause) {
            LOGGER.debug("DnsNameResolverBuilder#socketChannelType(Class, boolean) is available only starting from Netty 4.1.105.Final. Detected Netty version: {}", (Object)NETTY_VERSION, (Object)cause);
            tcpFallbackOnTimeout = null;
        }
        TCP_FALLBACK_ON_TIMEOUT = tcpFallbackOnTimeout;
        try {
            datagramChannelStrategy = MethodHandles.publicLookup().findVirtual(DnsNameResolverBuilder.class, "datagramChannelStrategy", MethodType.methodType(DnsNameResolverBuilder.class, Class.forName("io.netty.resolver.dns.DnsNameResolverChannelStrategy")));
            DnsNameResolverBuilderUtils.datagramChannelStrategy(datagramChannelStrategy, builder, DEFAULT_DATAGRAM_CHANNEL_STRATEGY);
        }
        catch (Throwable cause) {
            LOGGER.debug("DnsNameResolverBuilder#datagramChannelStrategy(DnsNameResolverChannelStrategy) is available only starting from Netty 4.1.114.Final. Detected Netty version: {}", (Object)NETTY_VERSION, (Object)cause);
            datagramChannelStrategy = null;
        }
        DATAGRAM_CHANNEL_STRATEGY = datagramChannelStrategy;
    }

    private static final class LazyHolder {
        private LazyHolder() {
        }

        static DnsNameResolverChannelStrategy toNettyStrategy(String strategy) {
            try {
                return DnsNameResolverChannelStrategy.valueOf((String)strategy);
            }
            catch (IllegalArgumentException e) {
                DnsNameResolverChannelStrategy fallback = DnsNameResolverChannelStrategy.ChannelPerResolver;
                LOGGER.warn("Unknown {} value: {}. Fallback to {}", new Object[]{DnsNameResolverChannelStrategy.class.getName(), strategy, fallback});
                return fallback;
            }
        }
    }
}

