/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.dns.discovery.netty.DnsClientFilter;
import io.servicetalk.dns.discovery.netty.DnsClientFilterFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Objects;

final class RetryingDnsClientFilter
implements DnsClientFilterFactory {
    private final BiIntFunction<Throwable, Completable> retryStrategy;

    RetryingDnsClientFilter() {
        this((BiIntFunction<Throwable, Completable>)RetryStrategies.retryWithConstantBackoffAndJitter((int)Integer.MAX_VALUE, t -> t instanceof UnknownHostException, (Duration)Duration.ofSeconds(60L), (Executor)Executors.immediate()));
    }

    RetryingDnsClientFilter(BiIntFunction<Throwable, Completable> retryStrategy) {
        this.retryStrategy = Objects.requireNonNull(retryStrategy);
    }

    @Override
    public DnsClientFilter create(DnsClient dnsClient) {
        return new DnsClientFilter(dnsClient){

            @Override
            public Publisher<ServiceDiscovererEvent<InetAddress>> dnsQuery(String hostName) {
                return super.dnsQuery(hostName).retryWhen(RetryingDnsClientFilter.this.retryStrategy);
            }

            @Override
            public Publisher<ServiceDiscovererEvent<InetSocketAddress>> dnsSrvQuery(String serviceName) {
                return super.dnsSrvQuery(serviceName).retryWhen(RetryingDnsClientFilter.this.retryStrategy);
            }
        };
    }
}

