/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.dns.discovery.netty.DnsServerAddressStream;
import java.net.InetSocketAddress;
import java.util.Objects;

public final class SingletonDnsServerAddresses
implements DnsServerAddressStream {
    private final InetSocketAddress address;

    public SingletonDnsServerAddresses(InetSocketAddress address) {
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("cannot use an unresolved DNS server address: " + address);
        }
        this.address = Objects.requireNonNull(address);
    }

    @Override
    public InetSocketAddress next() {
        return this.address;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public DnsServerAddressStream duplicate() {
        return this;
    }

    public String toString() {
        return "singleton(" + this.address + ")";
    }
}

