/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererFilterFactory;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.dns.discovery.netty.DefaultDnsServiceDiscoverer;
import io.servicetalk.dns.discovery.netty.DnsResolverAddressTypes;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import io.servicetalk.dns.discovery.netty.RetryingDnsServiceDiscovererFilter;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class DefaultDnsServiceDiscovererBuilder {
    @Nullable
    private DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    @Nullable
    private DnsResolverAddressTypes dnsResolverAddressTypes;
    @Nullable
    private Integer ndots;
    private Predicate<Throwable> invalidateHostsOnDnsFailure = this.defaultInvalidateHostsOnDnsFailurePredicate();
    @Nullable
    private Boolean optResourceEnabled;
    @Nullable
    private IoExecutor ioExecutor;
    @Nullable
    private Duration queryTimeout;
    private boolean applyRetryFilter = true;
    private int minTTLSeconds = 10;
    private ServiceDiscovererFilterFactory<String, InetAddress, ServiceDiscovererEvent<InetAddress>> serviceDiscoveryFilterFactory = ServiceDiscovererFilterFactory.identity();

    public DefaultDnsServiceDiscovererBuilder minTTL(int minTTLSeconds) {
        if (minTTLSeconds < 1) {
            throw new IllegalArgumentException("minTTLSeconds: " + minTTLSeconds + " (expected > 1)");
        }
        this.minTTLSeconds = minTTLSeconds;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder dnsServerAddressStreamProvider(@Nullable DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder queryTimeout(Duration queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder invalidateHostsOnDnsFailure(Predicate<Throwable> invalidateHostsOnDnsFailure) {
        this.invalidateHostsOnDnsFailure = invalidateHostsOnDnsFailure;
        return this;
    }

    public Predicate<Throwable> defaultInvalidateHostsOnDnsFailurePredicate() {
        return t -> t instanceof UnknownHostException && !(t.getCause() instanceof DnsNameResolverTimeoutException);
    }

    public DefaultDnsServiceDiscovererBuilder dnsResolverAddressTypes(@Nullable DnsResolverAddressTypes dnsResolverAddressTypes) {
        this.dnsResolverAddressTypes = dnsResolverAddressTypes;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder noRetriesOnDnsFailures() {
        this.applyRetryFilter = false;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder appendFilter(ServiceDiscovererFilterFactory<String, InetAddress, ServiceDiscovererEvent<InetAddress>> factory) {
        this.serviceDiscoveryFilterFactory = this.serviceDiscoveryFilterFactory.append(factory);
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder ioExecutor(IoExecutor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    public ServiceDiscoverer<String, InetAddress, ServiceDiscovererEvent<InetAddress>> buildInetDiscoverer() {
        return this.newDefaultDnsServiceDiscoverer();
    }

    public ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> build() {
        return DefaultDnsServiceDiscovererBuilder.toHostAndPortDiscoverer(this.newDefaultDnsServiceDiscoverer());
    }

    private ServiceDiscoverer<String, InetAddress, ServiceDiscovererEvent<InetAddress>> newDefaultDnsServiceDiscoverer() {
        ServiceDiscovererFilterFactory factory = this.serviceDiscoveryFilterFactory;
        if (this.applyRetryFilter) {
            ServiceDiscovererFilterFactory defaultFilterFactory = serviceDiscoverer -> new RetryingDnsServiceDiscovererFilter((ServiceDiscoverer<String, InetAddress, ServiceDiscovererEvent<InetAddress>>)serviceDiscoverer, (BiIntFunction<Throwable, Completable>)RetryStrategies.retryWithConstantBackoffAndJitter((int)Integer.MAX_VALUE, t -> true, (Duration)Duration.ofSeconds(60L), (Executor)Executors.immediate()));
            factory = defaultFilterFactory.append(factory);
        }
        return factory.create((ServiceDiscoverer)new DefaultDnsServiceDiscoverer(this.ioExecutor == null ? GlobalExecutionContext.globalExecutionContext().ioExecutor() : this.ioExecutor, this.minTTLSeconds, this.ndots, this.invalidateHostsOnDnsFailure, this.optResourceEnabled, this.queryTimeout, this.dnsResolverAddressTypes, this.dnsServerAddressStreamProvider));
    }

    private static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> toHostAndPortDiscoverer(final ServiceDiscoverer<String, InetAddress, ServiceDiscovererEvent<InetAddress>> serviceDiscoverer) {
        return new ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>>(){

            public Completable closeAsync() {
                return serviceDiscoverer.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return serviceDiscoverer.closeAsyncGracefully();
            }

            public Completable onClose() {
                return serviceDiscoverer.onClose();
            }

            public Publisher<ServiceDiscovererEvent<InetSocketAddress>> discover(HostAndPort hostAndPort) {
                return serviceDiscoverer.discover((Object)hostAndPort.hostName()).map(originalEvent -> new DefaultServiceDiscovererEvent((Object)new InetSocketAddress((InetAddress)originalEvent.address(), hostAndPort.port()), originalEvent.isAvailable()));
            }
        };
    }
}

