/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererFilter;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingDnsServiceDiscovererFilter
extends ServiceDiscovererFilter<String, InetAddress, ServiceDiscovererEvent<InetAddress>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryingDnsServiceDiscovererFilter.class);
    private final BiIntFunction<Throwable, Completable> retryStrategy;

    public RetryingDnsServiceDiscovererFilter(ServiceDiscoverer<String, InetAddress, ServiceDiscovererEvent<InetAddress>> delegate, BiIntFunction<Throwable, Completable> retryStrategy) {
        super(delegate);
        this.retryStrategy = retryStrategy;
    }

    public Publisher<ServiceDiscovererEvent<InetAddress>> discover(String unresolvedAddress) {
        return super.discover((Object)unresolvedAddress).retryWhen((i, t) -> {
            if (this.shouldRetry((Throwable)t)) {
                LOGGER.warn("Unable to resolve host {}", (Object)unresolvedAddress, t);
                return (Completable)this.retryStrategy.apply(i, t);
            }
            return Completable.failed((Throwable)t);
        });
    }

    protected boolean shouldRetry(Throwable cause) {
        return cause instanceof UnknownHostException;
    }
}

