/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergedExecutors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;

final class PublishAndSubscribeOnPublishers {
    private PublishAndSubscribeOnPublishers() {
    }

    static <T> void deliverOnSubscribeAndOnError(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider, Throwable cause) {
        SubscriberUtils.deliverErrorFromSource((PublisherSource.Subscriber)signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriber(subscriber, contextMap)), (Throwable)cause);
    }

    static <T> Publisher<T> publishAndSubscribeOn(Publisher<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishAndSubscribeOn(executor, original);
    }

    @Deprecated
    static <T> Publisher<T> publishAndSubscribeOnOverride(Publisher<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishAndSubscribeOnOverride(original, executor);
    }

    static <T> Publisher<T> publishOn(Publisher<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishOn(executor, original);
    }

    @Deprecated
    static <T> Publisher<T> publishOnOverride(Publisher<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishOnOverride(original, executor);
    }

    static <T> Publisher<T> subscribeOn(Publisher<T> original, Executor executor) {
        return original.executor() == executor ? original : new SubscribeOn(executor, original);
    }

    @Deprecated
    static <T> Publisher<T> subscribeOnOverride(Publisher<T> original, Executor executor) {
        return original.executor() == executor ? original : new SubscribeOnOverride(original, executor);
    }

    private static final class SubscribeOnOverride<T>
    extends AbstractSynchronousPublisherOperator<T, T> {
        SubscribeOnOverride(Publisher<T> original, Executor executor) {
            super(original, MergedExecutors.mergeAndOffloadSubscribe(original.executor(), executor));
        }

        @Override
        public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
            return subscriber;
        }
    }

    private static final class SubscribeOn<T>
    extends AbstractNoHandleSubscribePublisher<T> {
        private final Publisher<T> original;

        SubscribeOn(Executor executor, Publisher<T> original) {
            super(MergedExecutors.mergeAndOffloadSubscribe(original.executor(), executor));
            this.original = original;
        }

        @Override
        void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(subscriber);
        }
    }

    private static final class PublishOnOverride<T>
    extends AbstractSynchronousPublisherOperator<T, T> {
        PublishOnOverride(Publisher<T> original, Executor executor) {
            super(original, MergedExecutors.mergeAndOffloadPublish(original.executor(), executor));
        }

        @Override
        public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
            return subscriber;
        }
    }

    private static final class PublishOn<T>
    extends AbstractNoHandleSubscribePublisher<T> {
        private final Publisher<T> original;

        PublishOn(Executor executor, Publisher<T> original) {
            super(MergedExecutors.mergeAndOffloadPublish(original.executor(), executor));
            this.original = original;
        }

        @Override
        void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriber(subscriber, contextMap)));
        }
    }

    private static final class PublishAndSubscribeOnOverride<T>
    extends AbstractSynchronousPublisherOperator<T, T> {
        PublishAndSubscribeOnOverride(Publisher<T> original, Executor executor) {
            super(original, executor);
        }

        @Override
        public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
            return subscriber;
        }
    }

    private static final class PublishAndSubscribeOn<T>
    extends AbstractNoHandleSubscribePublisher<T> {
        private final Publisher<T> original;

        PublishAndSubscribeOn(Executor executor, Publisher<T> original) {
            super(executor);
            this.original = original;
        }

        @Override
        void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriber(subscriber, contextMap)));
        }
    }
}

