/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class FilterPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Predicate<? super T> predicate;

    FilterPublisher(Publisher<T> source, Predicate<? super T> predicate, Executor executor) {
        super(source, executor);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(final PublisherSource.Subscriber<? super T> subscriber) {
        return new PublisherSource.Subscriber<T>(){
            @Nullable
            private PublisherSource.Subscription subscription;

            public void onSubscribe(PublisherSource.Subscription s) {
                if (SubscriberUtils.checkDuplicateSubscription((PublisherSource.Subscription)this.subscription, (PublisherSource.Subscription)s)) {
                    this.subscription = ConcurrentSubscription.wrap((PublisherSource.Subscription)s);
                    subscriber.onSubscribe(this.subscription);
                }
            }

            public void onNext(T t) {
                if (FilterPublisher.this.predicate.test(t)) {
                    subscriber.onNext(t);
                } else {
                    assert (this.subscription != null) : "Subscription can not be null in onNext.";
                    this.subscription.request(1L);
                }
            }

            public void onError(Throwable t) {
                subscriber.onError(t);
            }

            public void onComplete() {
                subscriber.onComplete();
            }
        };
    }
}

