/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public final class VerificationTestUtils {
    private VerificationTestUtils() {
    }

    public static void verifySuppressed(@Nullable Throwable holder, Throwable expectedSuppressedCause) {
        Assertions.assertNotNull((Object)holder);
        boolean found = false;
        for (Throwable actualSuppressed : holder.getSuppressed()) {
            if (actualSuppressed != expectedSuppressedCause) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, () -> "couldn't find suppressed cause " + expectedSuppressedCause);
    }

    public static void expectThrowable(Runnable runnable, Class<? extends Throwable> expected) {
        VerificationTestUtils.expectThrowable(runnable, (Matcher<Throwable>)Matchers.instanceOf(expected));
    }

    public static void expectThrowable(Runnable runnable, Matcher<Throwable> matcher) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            MatcherAssert.assertThat((Object)t, matcher);
            return;
        }
        Assertions.fail((String)"Expected AssertionError");
    }

    public static <T1 extends Throwable, T2 extends Throwable> T1 assertThrows(Class<T1> expectedClass, @Nullable Class<T2> optionalWrapperClass, Executable executable) {
        if (optionalWrapperClass == null) {
            return (T1)Assertions.assertThrows(expectedClass, (Executable)executable);
        }
        try {
            executable.execute();
        }
        catch (Throwable cause) {
            if (expectedClass.isInstance(cause)) {
                return (T1)cause;
            }
            if (optionalWrapperClass.isInstance(cause) && expectedClass.isInstance(cause.getCause())) {
                return (T1)cause.getCause();
            }
            throw new AssertionError((Object)("expected " + VerificationTestUtils.className(expectedClass) + " optionally wrapped by " + VerificationTestUtils.className(optionalWrapperClass) + " but got " + VerificationTestUtils.className(cause) + " caused by " + VerificationTestUtils.classNameNullable(cause.getCause())));
        }
        throw new AssertionError((Object)("expected " + VerificationTestUtils.className(expectedClass) + " optionally wrapped by " + VerificationTestUtils.className(optionalWrapperClass) + " but nothing was thrown"));
    }

    private static String classNameNullable(@Nullable Object o) {
        return o == null ? "null" : VerificationTestUtils.className(o);
    }

    private static String className(Class<?> o) {
        return o.getCanonicalName();
    }

    private static String className(Object o) {
        return o.getClass().getCanonicalName();
    }
}

