/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletableProcessor;
import io.servicetalk.concurrent.api.Executor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class TestExecutor
implements Executor {
    private static final AtomicInteger INSTANCES = new AtomicInteger();
    private final Queue<RunnableWrapper> tasks = new ConcurrentLinkedQueue<RunnableWrapper>();
    private final ConcurrentNavigableMap<Long, Queue<RunnableWrapper>> scheduledTasksByNano = new ConcurrentSkipListMap<Long, Queue<RunnableWrapper>>();
    private final long nanoOffset;
    private long currentNanos;
    private final CompletableProcessor closeProcessor = new CompletableProcessor();
    private final AtomicInteger tasksExecuted = new AtomicInteger();
    private final AtomicInteger scheduledTasksExecuted = new AtomicInteger();
    private final String instanceName = this.getClass().getSimpleName() + "-" + INSTANCES.incrementAndGet();

    public TestExecutor() {
        this(ThreadLocalRandom.current().nextLong());
    }

    TestExecutor(long epochNanos) {
        this.currentNanos = epochNanos;
        this.nanoOffset = epochNanos - Long.MIN_VALUE;
    }

    public Cancellable execute(Runnable task) throws RejectedExecutionException {
        RunnableWrapper wrappedTask = new RunnableWrapper(this.instanceName, task);
        this.tasks.add(wrappedTask);
        return () -> this.tasks.remove(wrappedTask);
    }

    public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
        RunnableWrapper wrappedTask = new RunnableWrapper(this.instanceName, task);
        long scheduledNanos = this.currentScheduledNanos() + unit.toNanos(delay);
        Queue tasksForNanos = this.scheduledTasksByNano.computeIfAbsent(scheduledNanos, k -> new ConcurrentLinkedQueue());
        tasksForNanos.add(wrappedTask);
        return () -> this.scheduledTasksByNano.computeIfPresent(scheduledNanos, (k, tasks) -> {
            if (tasks.remove(wrappedTask) && tasks.isEmpty()) {
                this.removedScheduledQueue(scheduledNanos);
            }
            return tasks;
        });
    }

    public Completable onClose() {
        return this.closeProcessor;
    }

    public Completable closeAsync() {
        return new Completable(){

            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                TestExecutor.this.closeProcessor.subscribe(subscriber);
                TestExecutor.this.closeProcessor.onComplete();
            }
        };
    }

    private long currentScheduledNanos() {
        return this.currentNanos() - this.nanoOffset;
    }

    public long currentNanos() {
        return this.currentNanos;
    }

    public long currentMillis() {
        return this.currentTime(TimeUnit.NANOSECONDS);
    }

    public long currentTime(TimeUnit unit) {
        return unit.convert(this.currentNanos, TimeUnit.NANOSECONDS);
    }

    public TestExecutor advanceTimeBy(long time, TimeUnit unit) {
        this.advanceTimeByNoExecuteTasks(time, unit);
        this.executeScheduledTasks();
        return this;
    }

    public TestExecutor advanceTimeByNoExecuteTasks(long time, TimeUnit unit) {
        if (time <= 0L) {
            throw new IllegalArgumentException("time (" + time + ") must be >0");
        }
        this.currentNanos += unit.toNanos(time);
        return this;
    }

    public TestExecutor executeTasks() {
        TestExecutor.execute(this.tasks, this.tasksExecuted);
        return this;
    }

    public TestExecutor executeNextTask() {
        if (!TestExecutor.executeOne(this.tasks, this.tasksExecuted)) {
            throw new IllegalStateException("No tasks to execute");
        }
        return this;
    }

    public TestExecutor executeScheduledTasks() {
        NavigableMap headMap = this.scheduledTasksByNano.headMap((Object)this.currentScheduledNanos(), true);
        Iterator i = headMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            TestExecutor.execute((Queue)entry.getValue(), this.scheduledTasksExecuted);
            i.remove();
        }
        return this;
    }

    public TestExecutor executeNextScheduledTask() {
        NavigableMap headMap = this.scheduledTasksByNano.headMap((Object)this.currentScheduledNanos(), true);
        Map.Entry entry = headMap.firstEntry();
        if (entry != null && TestExecutor.executeOne((Queue)entry.getValue(), this.scheduledTasksExecuted)) {
            if (((Queue)entry.getValue()).isEmpty()) {
                this.removedScheduledQueue((Long)entry.getKey());
            }
            return this;
        }
        throw new IllegalStateException("No scheduled tasks to execute");
    }

    public int queuedTasksPending() {
        return this.tasks.size();
    }

    public int scheduledTasksPending() {
        return this.scheduledTasksByNano.values().stream().mapToInt(Collection::size).sum();
    }

    public int queuedTasksExecuted() {
        return this.tasksExecuted.get();
    }

    public int scheduledTasksExecuted() {
        return this.scheduledTasksExecuted.get();
    }

    private void removedScheduledQueue(Long scheduledNanos) {
        Queue<RunnableWrapper> existingQueue;
        Queue removedQueue = (Queue)this.scheduledTasksByNano.remove(scheduledNanos);
        if (!removedQueue.isEmpty() && (existingQueue = this.scheduledTasksByNano.putIfAbsent(scheduledNanos, removedQueue)) != null) {
            existingQueue.addAll(removedQueue);
        }
    }

    private static void execute(Queue<RunnableWrapper> tasks, AtomicInteger taskCount) {
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            Runnable task = (Runnable)i.next();
            i.remove();
            taskCount.incrementAndGet();
            task.run();
        }
    }

    @Nullable
    private static boolean executeOne(Queue<RunnableWrapper> tasks, AtomicInteger taskCount) {
        Iterator i = tasks.iterator();
        if (i.hasNext()) {
            Runnable task = (Runnable)i.next();
            i.remove();
            taskCount.incrementAndGet();
            task.run();
            return true;
        }
        return false;
    }

    private static final class RunnableWrapper
    implements Runnable {
        private final String threadName;
        private final Runnable delegate;

        private RunnableWrapper(String threadName, Runnable delegate) {
            this.threadName = threadName;
            this.delegate = AsyncContext.wrapRunnable((Runnable)delegate);
        }

        @Override
        public void run() {
            Thread current = Thread.currentThread();
            String oldName = current.getName();
            current.setName(this.threadName);
            try {
                this.delegate.run();
            }
            finally {
                current.setName(oldName);
            }
        }
    }
}

