/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.TestExecutor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class ExecutorExtension<E extends Executor>
implements BeforeEachCallback,
AfterEachCallback {
    private final Supplier<E> eSupplier;
    @Nullable
    private E executor;

    private ExecutorExtension(Supplier<E> eSupplier) {
        this.eSupplier = eSupplier;
    }

    public static ExecutorExtension<Executor> withCachedExecutor() {
        return new ExecutorExtension<Executor>(Executors::newCachedThreadExecutor);
    }

    public static ExecutorExtension<TestExecutor> withTestExecutor() {
        return new ExecutorExtension<TestExecutor>(TestExecutor::new);
    }

    public static ExecutorExtension<Executor> withExecutor(Supplier<Executor> executorSupplier) {
        return new ExecutorExtension<Executor>(executorSupplier);
    }

    public static ExecutorExtension<Executor> withCachedExecutor(String namePrefix) {
        return new ExecutorExtension<Executor>(() -> Executors.newCachedThreadExecutor((ThreadFactory)new DefaultThreadFactory(namePrefix, true, 5)));
    }

    public E executor() {
        assert (this.executor != null) : "Executor was not initialized";
        return this.executor;
    }

    public void beforeEach(ExtensionContext context) {
        this.executor = (Executor)this.eSupplier.get();
    }

    public void afterEach(ExtensionContext context) throws ExecutionException, InterruptedException {
        if (this.executor == null) {
            return;
        }
        this.executor.closeAsync().toFuture().get();
    }
}

