/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class RetryStrategies {
    private RetryStrategies() {
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffFullJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration delay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        return (retryCount, cause) -> retryCount <= maxRetries && causeFilter.test((Throwable)cause) ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, delayNanos), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffFullJitter(Predicate<Throwable> causeFilter, Duration delay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        return (retryCount, cause) -> causeFilter.test((Throwable)cause) ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, delayNanos), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffDeltaJitter(Predicate<Throwable> causeFilter, Duration delay, Duration jitter, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        long jitterNanos = jitter.toNanos();
        RetryStrategies.checkJitterDelta(jitterNanos, delayNanos);
        long lowerBound = delayNanos - jitterNanos;
        long upperBound = delayNanos + jitterNanos;
        return (retryCount, cause) -> causeFilter.test((Throwable)cause) ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(lowerBound, upperBound), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffDeltaJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration delay, Duration jitter, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        long jitterNanos = jitter.toNanos();
        RetryStrategies.checkJitterDelta(jitterNanos, delayNanos);
        long lowerBound = delayNanos - jitterNanos;
        long upperBound = delayNanos + jitterNanos;
        return (retryCount, cause) -> retryCount <= maxRetries && causeFilter.test((Throwable)cause) ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(lowerBound, upperBound), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffFullJitter(Predicate<Throwable> causeFilter, Duration initialDelay, Duration maxDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> causeFilter.test((Throwable)cause) ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount)), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffFullJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration initialDelay, Duration maxDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> retryCount <= maxRetries && causeFilter.test((Throwable)cause) ? timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount)), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffDeltaJitter(Predicate<Throwable> causeFilter, Duration initialDelay, Duration jitter, Duration maxDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long jitterNanos = jitter.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> {
            if (!causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            long baseDelayNanos = RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount);
            return timerExecutor.timer(ThreadLocalRandom.current().nextLong(Math.max(0L, baseDelayNanos - jitterNanos), Math.min(maxDelayNanos, FlowControlUtils.addWithOverflowProtection((long)baseDelayNanos, (long)jitterNanos))), TimeUnit.NANOSECONDS);
        };
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffDeltaJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration initialDelay, Duration jitter, Duration maxDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long jitterNanos = jitter.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> {
            if (retryCount > maxRetries || !causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            long baseDelayNanos = RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount);
            return timerExecutor.timer(ThreadLocalRandom.current().nextLong(Math.max(0L, baseDelayNanos - jitterNanos), Math.min(maxDelayNanos, FlowControlUtils.addWithOverflowProtection((long)baseDelayNanos, (long)jitterNanos))), TimeUnit.NANOSECONDS);
        };
    }

    static long baseDelayNanos(long initialDelayNanos, long maxDelayNanos, long maxInitialShift, int count) {
        return Math.min(maxDelayNanos, initialDelayNanos << (int)Math.min(maxInitialShift, (long)(count - 1)));
    }

    static void checkMaxRetries(int maxRetries) {
        if (maxRetries <= 0) {
            throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected: >0)");
        }
    }

    static void checkJitterDelta(long jitterNanos, long delayNanos) {
        if (jitterNanos > delayNanos || Long.MAX_VALUE - delayNanos < jitterNanos) {
            throw new IllegalArgumentException("jitter " + jitterNanos + "ns would result in [under|over]flow as a delta to delay " + delayNanos + "ns");
        }
    }

    static long maxShift(long v) {
        return Long.numberOfLeadingZeros(v) - 1;
    }
}

