/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.function.BiPredicate;

final class RedoPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Publisher<T> original;
    private final BiPredicate<Integer, TerminalNotification> shouldRedo;

    RedoPublisher(Publisher<T> original, BiPredicate<Integer, TerminalNotification> shouldRedo, Executor executor) {
        super(executor);
        this.original = original;
        this.shouldRedo = shouldRedo;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new RedoSubscriber<T>(new SequentialSubscription(), 0, subscriber, contextMap.copy(), contextProvider, this, signalOffloader), signalOffloader, contextMap, contextProvider);
    }

    private static final class RedoSubscriber<T>
    extends AbstractRedoSubscriber<T> {
        private final RedoPublisher<T> redoPublisher;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        private final SignalOffloader offloader;

        RedoSubscriber(SequentialSubscription subscription, int redoCount, PublisherSource.Subscriber<? super T> subscriber, AsyncContextMap contextMap, AsyncContextProvider contextProvider, RedoPublisher<T> redoPublisher, SignalOffloader offloader) {
            super(subscription, redoCount, subscriber);
            this.redoPublisher = redoPublisher;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
            this.offloader = offloader;
        }

        public void onNext(T t) {
            this.subscription.itemReceived();
            this.subscriber.onNext(t);
        }

        public void onError(Throwable t) {
            this.tryRedo(TerminalNotification.error((Throwable)t));
        }

        public void onComplete() {
            this.tryRedo(TerminalNotification.complete());
        }

        private void tryRedo(TerminalNotification notification) {
            boolean shouldRedo;
            try {
                shouldRedo = ((RedoPublisher)this.redoPublisher).shouldRedo.test(this.redoCount + 1, notification);
            }
            catch (Throwable cause) {
                Throwable originalCause = notification.cause();
                if (originalCause != null) {
                    cause.addSuppressed(originalCause);
                }
                this.subscriber.onError(cause);
                return;
            }
            if (shouldRedo) {
                ((RedoPublisher)this.redoPublisher).original.delegateSubscribe(new RedoSubscriber<T>(this.subscription, this.redoCount + 1, this.subscriber, this.contextMap.copy(), this.contextProvider, this.redoPublisher, this.offloader), this.offloader, this.contextMap, this.contextProvider);
            } else {
                notification.terminate(this.subscriber);
            }
        }
    }

    static abstract class AbstractRedoSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        final SequentialSubscription subscription;
        final int redoCount;
        final PublisherSource.Subscriber<? super T> subscriber;

        AbstractRedoSubscriber(SequentialSubscription subscription, int redoCount, PublisherSource.Subscriber<? super T> subscriber) {
            this.subscription = subscription;
            this.redoCount = redoCount;
            this.subscriber = subscriber;
        }

        public final void onSubscribe(PublisherSource.Subscription s) {
            s = this.decorate(s);
            this.subscription.switchTo(s);
            if (this.redoCount == 0) {
                this.subscriber.onSubscribe((PublisherSource.Subscription)this.subscription);
            }
        }

        PublisherSource.Subscription decorate(PublisherSource.Subscription s) {
            return s;
        }
    }
}

