/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class OnErrorResumeCompletable
extends AbstractNoHandleSubscribeCompletable {
    private final Completable original;
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Completable> nextFactory;

    OnErrorResumeCompletable(Completable original, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Completable> nextFactory, Executor executor) {
        super(executor);
        this.original = original;
        this.predicate = Objects.requireNonNull(predicate);
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ResumeSubscriber(subscriber, signalOffloader, contextMap, contextProvider), signalOffloader, contextMap, contextProvider);
    }

    private final class ResumeSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber subscriber;
        private final SignalOffloader signalOffloader;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        private boolean resubscribed;

        ResumeSubscriber(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.signalOffloader = signalOffloader;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.subscriber.onSubscribe((Cancellable)this.sequentialCancellable);
            } else {
                this.resubscribed = true;
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void onError(Throwable throwable) {
            Completable next;
            try {
                next = !this.resubscribed && OnErrorResumeCompletable.this.predicate.test(throwable) ? (Completable)Objects.requireNonNull(OnErrorResumeCompletable.this.nextFactory.apply(throwable)) : null;
            }
            catch (Throwable t) {
                t.addSuppressed(throwable);
                this.subscriber.onError(t);
                return;
            }
            if (next == null) {
                this.subscriber.onError(throwable);
            } else {
                CompletableSource.Subscriber offloadedSubscriber = this.signalOffloader.offloadSubscriber(this.contextProvider.wrapCompletableSubscriber(this, this.contextMap));
                next.subscribeInternal(offloadedSubscriber);
            }
        }
    }
}

