/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractMergeCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletableDynamicCountSubscriber;
import io.servicetalk.concurrent.api.Executor;
import java.util.Objects;

final class IterableMergeCompletable
extends AbstractMergeCompletableOperator<CompletableDynamicCountSubscriber> {
    private final Iterable<? extends Completable> others;
    private final boolean delayError;

    IterableMergeCompletable(boolean delayError, Completable original, Iterable<? extends Completable> others, Executor executor) {
        super(original, executor);
        this.delayError = delayError;
        this.others = Objects.requireNonNull(others);
    }

    @Override
    public CompletableDynamicCountSubscriber apply(CompletableSource.Subscriber subscriber) {
        return new CompletableDynamicCountSubscriber(subscriber, this.delayError);
    }

    @Override
    void doMerge(CompletableDynamicCountSubscriber subscriber) {
        long count = 1L;
        for (Completable completable : this.others) {
            ++count;
            completable.subscribeInternal(subscriber);
        }
        subscriber.setExpectedCount(count);
    }
}

