/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.CopyOnWriteAsyncContextMap;

final class AsyncContextMapThreadLocal {
    static final ThreadLocal<AsyncContextMap> contextThreadLocal = ThreadLocal.withInitial(AsyncContextMapThreadLocal::newContextMap);

    AsyncContextMapThreadLocal() {
    }

    private static AsyncContextMap newContextMap() {
        return new CopyOnWriteAsyncContextMap();
    }

    AsyncContextMap get() {
        Thread t = Thread.currentThread();
        if (t instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)t);
            AsyncContextMap map = asyncContextMapHolder.asyncContextMap();
            if (map == null) {
                map = AsyncContextMapThreadLocal.newContextMap();
                asyncContextMapHolder.asyncContextMap(map);
            }
            return map;
        }
        return contextThreadLocal.get();
    }

    void set(AsyncContextMap asyncContextMap) {
        Thread t = Thread.currentThread();
        if (t instanceof AsyncContextMapHolder) {
            ((AsyncContextMapHolder)((Object)t)).asyncContextMap(asyncContextMap);
        } else {
            contextThreadLocal.set(asyncContextMap);
        }
    }

    void remove() {
        Thread t = Thread.currentThread();
        if (t instanceof AsyncContextMapHolder) {
            ((AsyncContextMapHolder)((Object)t)).asyncContextMap(null);
        } else {
            contextThreadLocal.remove();
        }
    }
}

