/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.TestCancellable;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import java.util.concurrent.atomic.AtomicLong;

public final class TestSubscription
extends TestCancellable
implements PublisherSource.Subscription {
    private final AtomicLong requested = new AtomicLong();
    private volatile boolean requestCalled;

    public void request(long n) {
        this.requestCalled = true;
        this.requested.accumulateAndGet(n, (x, y) -> {
            if (x < 0L) {
                return x;
            }
            if (y <= 0L) {
                return y;
            }
            return FlowControlUtils.addWithOverflowProtection((long)x, (long)y);
        });
        this.wakeupWaiters();
    }

    public long requested() {
        return this.requested.get();
    }

    public boolean requestedEquals(long value) {
        return value == 0L && this.requestCalled || value != 0L && this.requested.get() == value;
    }

    public void awaitRequestN(long amount) throws InterruptedException {
        Object object = this.waitingLock;
        synchronized (object) {
            while (true) {
                long r;
                if (this.isRequestNInvalid(r = this.requested.get()) || r >= amount) {
                    return;
                }
                this.waitingLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void awaitRequestNUninterruptibly(long amount) {
        long r;
        boolean interrupted = false;
        Object object = this.waitingLock;
        // MONITORENTER : object
        while (!this.isRequestNInvalid(r = this.requested.get()) && r < amount) {
            try {
                this.waitingLock.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        // MONITOREXIT : object
        if (!interrupted) return;
        Thread.currentThread().interrupt();
    }

    public String toString() {
        return "requestN: " + this.requested.get() + " requestCalled: " + this.requestCalled;
    }

    private boolean isRequestNInvalid(long r) {
        return r < 0L || r == 0L && this.requestCalled;
    }
}

