/*
 * Copyright © 2019 Apple Inc. and the ServiceTalk project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource.Subscription;

import static java.util.Objects.requireNonNull;

final class MergedCancellableWithSubscription implements Subscription {
    private final Subscription subscription;
    private final Cancellable cancellable;

    MergedCancellableWithSubscription(Subscription subscription, Cancellable cancellable) {
        this.subscription = requireNonNull(subscription);
        this.cancellable = requireNonNull(cancellable);
    }

    @Override
    public void request(final long l) {
        subscription.request(l);
    }

    @Override
    public void cancel() {
        try {
            subscription.cancel();
        } finally {
            cancellable.cancel();
        }
    }
}
