/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class MapSingle<T, R>
extends AbstractSynchronousSingleOperator<T, R> {
    private final Function<? super T, ? extends R> mapper;

    MapSingle(Single<T> source, Function<? super T, ? extends R> mapper, Executor executor) {
        super(source, executor);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(final SingleSource.Subscriber<? super R> subscriber) {
        return new SingleSource.Subscriber<T>(){

            public void onSubscribe(Cancellable cancellable) {
                subscriber.onSubscribe(cancellable);
            }

            public void onSuccess(@Nullable T result) {
                Object mappedResult;
                try {
                    mappedResult = MapSingle.this.mapper.apply(result);
                }
                catch (Throwable cause) {
                    subscriber.onError(cause);
                    return;
                }
                subscriber.onSuccess(mappedResult);
            }

            public void onError(Throwable t) {
                subscriber.onError(t);
            }
        };
    }
}

