/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AbstractOffloaderAwareExecutor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.NoopOffloader;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

final class ImmediateExecutor
extends AbstractOffloaderAwareExecutor {
    private static final io.servicetalk.concurrent.api.Executor IMMEDIATE = Executors.from(Runnable::run);
    static final io.servicetalk.concurrent.api.Executor IMMEDIATE_EXECUTOR = new ImmediateExecutor();

    private ImmediateExecutor() {
    }

    public SignalOffloader newSignalOffloader(Executor executor) {
        return NoopOffloader.NOOP_OFFLOADER;
    }

    public boolean hasThreadAffinity() {
        return false;
    }

    public Cancellable execute(Runnable task) throws RejectedExecutionException {
        task.run();
        return Cancellable.IGNORE_CANCEL;
    }

    public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
        return IMMEDIATE.schedule(task, delay, unit);
    }

    @Override
    void doClose() {
    }
}

