/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.DuplicateSubscribeException;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FromInputStreamPublisher
extends Publisher<byte[]>
implements PublisherSource<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FromInputStreamPublisher.class);
    private static final AtomicIntegerFieldUpdater<FromInputStreamPublisher> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(FromInputStreamPublisher.class, "subscribed");
    private volatile int subscribed;
    private final InputStream stream;

    FromInputStreamPublisher(InputStream stream) {
        this.stream = Objects.requireNonNull(stream);
    }

    public void subscribe(PublisherSource.Subscriber<? super byte[]> subscriber) {
        this.subscribeInternal(subscriber);
    }

    @Override
    protected void handleSubscribe(PublisherSource.Subscriber<? super byte[]> subscriber) {
        if (subscribedUpdater.compareAndSet(this, 0, 1)) {
            try {
                subscriber.onSubscribe((PublisherSource.Subscription)new InputStreamPublisherSubscription(this.stream, subscriber));
            }
            catch (Throwable t) {
                SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
            }
        } else {
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new DuplicateSubscribeException(null, subscriber));
        }
    }

    private static final class InputStreamPublisherSubscription
    implements PublisherSource.Subscription {
        private static final int END_OF_FILE = -1;
        private static final int TERMINAL_SENT = -1;
        private final InputStream stream;
        private final PublisherSource.Subscriber<? super byte[]> subscriber;
        private long requested;
        @Nullable
        private byte[] buffer;
        private int writeIdx;
        private boolean ignoreRequests;

        InputStreamPublisherSubscription(InputStream stream, PublisherSource.Subscriber<? super byte[]> subscriber) {
            this.stream = stream;
            this.subscriber = subscriber;
        }

        public void request(long n) {
            if (this.requested == -1L) {
                return;
            }
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                this.sendOnError(this.subscriber, this.closeStreamOnError(SubscriberUtils.newExceptionForInvalidRequestN((long)n)));
                return;
            }
            this.requested = FlowControlUtils.addWithOverflowProtection((long)this.requested, (long)n);
            if (this.ignoreRequests) {
                return;
            }
            this.ignoreRequests = true;
            this.readAndDeliver(this.subscriber);
            if (this.requested != -1L) {
                this.ignoreRequests = false;
            }
        }

        public void cancel() {
            if (this.trySetTerminalSent()) {
                this.closeStream(this.subscriber);
            }
        }

        private void readAndDeliver(PublisherSource.Subscriber<? super byte[]> subscriber) {
            try {
                do {
                    int available;
                    if ((available = this.stream.available()) == 0) {
                        available = this.buffer != null ? this.buffer.length : 1;
                    }
                    available = this.fillBufferAvoidingBlocking(available);
                    this.emitSingleBuffer(subscriber);
                    if (available != -1) continue;
                    this.sendOnComplete(subscriber);
                    return;
                } while (this.requested > 0L);
            }
            catch (Throwable t) {
                this.sendOnError(subscriber, this.closeStreamOnError(t));
            }
        }

        private int fillBufferAvoidingBlocking(int available) throws IOException {
            if (this.buffer == null) {
                this.buffer = new byte[available];
            }
            while (this.writeIdx != this.buffer.length && available > 0) {
                int len = Math.min(this.buffer.length - this.writeIdx, available);
                int readActual = this.stream.read(this.buffer, this.writeIdx, len);
                if (readActual == -1) {
                    return -1;
                }
                available -= readActual;
                this.writeIdx += readActual;
            }
            return available;
        }

        private void emitSingleBuffer(PublisherSource.Subscriber<? super byte[]> subscriber) {
            byte[] b;
            if (this.writeIdx < 1) {
                return;
            }
            assert (this.buffer != null) : "should have a buffer when writeIdx > 0";
            if (this.writeIdx == this.buffer.length) {
                b = this.buffer;
                this.buffer = null;
            } else {
                b = new byte[this.writeIdx];
                System.arraycopy(this.buffer, 0, b, 0, this.writeIdx);
            }
            --this.requested;
            this.writeIdx = 0;
            subscriber.onNext((Object)b);
        }

        private void sendOnComplete(PublisherSource.Subscriber<? super byte[]> subscriber) {
            this.closeStream(subscriber);
            if (this.trySetTerminalSent()) {
                try {
                    subscriber.onComplete();
                }
                catch (Throwable t) {
                    LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", subscriber, (Object)t);
                }
            }
        }

        private <T extends Throwable> void sendOnError(PublisherSource.Subscriber<? super byte[]> subscriber, T t) {
            if (this.trySetTerminalSent()) {
                try {
                    subscriber.onError(t);
                }
                catch (Throwable tt) {
                    LOGGER.info("Ignoring exception from onError of Subscriber {}.", subscriber, (Object)tt);
                }
            }
        }

        private Throwable closeStreamOnError(Throwable t) {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return t;
        }

        private void closeStream(PublisherSource.Subscriber<? super byte[]> subscriber) {
            block2: {
                try {
                    this.stream.close();
                }
                catch (Throwable e) {
                    if (!this.trySetTerminalSent()) break block2;
                    this.sendOnError(subscriber, e);
                }
            }
        }

        private boolean trySetTerminalSent() {
            if (this.requested == -1L) {
                return false;
            }
            this.requested = -1L;
            return true;
        }
    }
}

