/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import javax.annotation.Nullable;

final class CompletableConcatWithCompletable
extends AbstractNoHandleSubscribeCompletable {
    private final Completable original;
    private final Completable next;

    CompletableConcatWithCompletable(Completable original, Completable next, Executor executor) {
        super(executor);
        this.original = original;
        this.next = Objects.requireNonNull(next);
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader offloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        CompletableSource.Subscriber offloadSubscriber = offloader.offloadSubscriber(contextProvider.wrapCompletableSubscriber(subscriber, contextMap));
        this.original.delegateSubscribe(new ConcatWithSubscriber(offloadSubscriber, this.next), offloader, contextMap, contextProvider);
    }

    private static final class ConcatWithSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber target;
        private final Completable next;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        private boolean nextSubscribed;

        ConcatWithSubscriber(CompletableSource.Subscriber target, Completable next) {
            this.target = target;
            this.next = next;
        }

        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.target.onSubscribe((Cancellable)this.sequentialCancellable);
            } else {
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        public void onComplete() {
            if (this.nextSubscribed) {
                this.target.onComplete();
            } else {
                this.nextSubscribed = true;
                this.next.subscribeInternal(this);
            }
        }

        public void onError(Throwable t) {
            this.target.onError(t);
        }
    }
}

