/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextExecutorPlugin;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.NoopAsyncContextProvider;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class AsyncContext {
    private static final int STATE_DISABLED = -1;
    private static final int STATE_INIT = 0;
    private static final int STATE_AUTO_ENABLED = 1;
    private static final int STATE_ENABLED = 2;
    private static final AtomicInteger ENABLED_STATE = new AtomicInteger(0);
    private static AsyncContextProvider provider = DefaultAsyncContextProvider.INSTANCE;

    private AsyncContext() {
    }

    static AsyncContextProvider provider() {
        return provider;
    }

    public static AsyncContextMap current() {
        return AsyncContext.provider().contextMap();
    }

    public static <T> void put(AsyncContextMap.Key<T> key, T value) {
        AsyncContext.current().put(key, value);
    }

    public static void putAll(Map<AsyncContextMap.Key<?>, Object> map) {
        AsyncContext.current().putAll(map);
    }

    public static void remove(AsyncContextMap.Key<?> key) {
        AsyncContext.current().remove(key);
    }

    public static void removeAll(Iterable<AsyncContextMap.Key<?>> entries) {
        AsyncContext.current().removeAll(entries);
    }

    public static void clear() {
        AsyncContext.current().clear();
    }

    @Nullable
    public static <T> T get(AsyncContextMap.Key<T> key) {
        return AsyncContext.current().get(key);
    }

    public static boolean containsKey(AsyncContextMap.Key<?> key) {
        return AsyncContext.current().containsKey(key);
    }

    public static boolean isEmpty() {
        return AsyncContext.current().isEmpty();
    }

    @Nullable
    public static AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
        return AsyncContext.current().forEach(consumer);
    }

    public static java.util.concurrent.Executor wrapJdkExecutor(java.util.concurrent.Executor executor) {
        return AsyncContext.provider().wrapJdkExecutor(executor);
    }

    public static Executor wrapExecutor(Executor executor) {
        return AsyncContext.provider().wrapExecutor(executor);
    }

    public static ExecutorService wrapJdkExecutorService(ExecutorService executor) {
        return AsyncContext.provider().wrapJdkExecutorService(executor);
    }

    public static ScheduledExecutorService wrapJdkScheduledExecutorService(ScheduledExecutorService executor) {
        return AsyncContext.provider().wrapJdkScheduledExecutorService(executor);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapRunnable(runnable, provider.contextMap());
    }

    public static <T> Consumer<T> wrapConsumer(Consumer<T> consumer) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapConsumer(consumer, provider.contextMap());
    }

    public static <T, U> Function<T, U> wrapFunction(Function<T, U> func) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapFunction(func, provider.contextMap());
    }

    public static <T, U> BiConsumer<T, U> wrapBiConsume(BiConsumer<T, U> consumer) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapBiConsumer(consumer, provider.contextMap());
    }

    public static <T, U, V> BiFunction<T, U, V> wrapBiFunction(BiFunction<T, U, V> func) {
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapBiFunction(func, provider.contextMap());
    }

    public static void disable() {
        if (ENABLED_STATE.getAndSet(-1) != -1) {
            AsyncContext.disable0();
        }
    }

    public static boolean isDisabled() {
        return ENABLED_STATE.get() == -1;
    }

    static void enable() {
        block1: {
            int enabledState;
            while (!ENABLED_STATE.compareAndSet(enabledState = ENABLED_STATE.get(), 2)) {
            }
            if (enabledState == 2 || enabledState == 1) break block1;
            AsyncContext.enable0();
        }
    }

    static void autoEnable() {
        if (ENABLED_STATE.compareAndSet(0, 1)) {
            AsyncContext.enable0();
        }
    }

    private static void enable0() {
        provider = DefaultAsyncContextProvider.INSTANCE;
        Executors.EXECUTOR_PLUGINS.add(AsyncContextExecutorPlugin.EXECUTOR_PLUGIN);
        if (ENABLED_STATE.get() == -1) {
            AsyncContext.disable0();
        }
    }

    private static void disable0() {
        provider = NoopAsyncContextProvider.INSTANCE;
        Executors.EXECUTOR_PLUGINS.remove(AsyncContextExecutorPlugin.EXECUTOR_PLUGIN);
    }
}

