/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class VerificationTestUtils {
    private VerificationTestUtils() {
    }

    public static void verifySuppressed(@Nullable Throwable holder, Throwable expectedSuppressedCause) {
        Assert.assertNotNull((Object)holder);
        boolean found = false;
        for (Throwable actualSuppressed : holder.getSuppressed()) {
            if (actualSuppressed != expectedSuppressedCause) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)("couldn't find suppressed cause " + expectedSuppressedCause), (boolean)found);
    }

    public static void expectThrowable(Runnable runnable, Class<? extends Throwable> expected) {
        VerificationTestUtils.expectThrowable(runnable, (Matcher<Throwable>)Matchers.instanceOf(expected));
    }

    public static void expectThrowable(Runnable runnable, Matcher<Throwable> matcher) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            MatcherAssert.assertThat((Object)t, matcher);
            return;
        }
        Assert.fail((String)"Expected AssertionError");
    }
}

