/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSingleSubscriber<T>
implements SingleSource.Subscriber<T> {
    private final Logger logger;
    private final SingleSource.Subscriber<T> delegate;

    public LoggingSingleSubscriber(String name, SingleSource.Subscriber<T> delegate) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.delegate = delegate;
    }

    public void onSubscribe(Cancellable c) {
        this.logger.info("onSubscribe({})", (Object)c);
        this.delegate.onSubscribe(() -> {
            this.logger.info("cancel()");
            c.cancel();
        });
    }

    public void onSuccess(T result) {
        this.logger.info("onSuccess({})", result);
        this.delegate.onSuccess(result);
    }

    public void onError(Throwable t) {
        this.logger.info("onError({})", (Object)t, null);
        this.delegate.onError(t);
    }
}

