/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.CancellableSet;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

@Deprecated
public class LegacyTestCompletable
extends Completable
implements CompletableSource.Subscriber {
    private final Queue<CompletableSource.Subscriber> subscribers = new ConcurrentLinkedQueue<CompletableSource.Subscriber>();
    private final CancellableSet dynamicCancellable = new CancellableSet();
    private final boolean invokeListenerPostCancel;
    private boolean deferOnSubscribe;
    @Nullable
    private TerminalNotification terminalNotification;

    public LegacyTestCompletable(boolean invokeListenerPostCancel, boolean deferOnSubscribe) {
        this.invokeListenerPostCancel = invokeListenerPostCancel;
        this.deferOnSubscribe = deferOnSubscribe;
    }

    public LegacyTestCompletable() {
        this(false, false);
    }

    public synchronized void handleSubscribe(CompletableSource.Subscriber subscriber) {
        this.subscribers.add(subscriber);
        this.dynamicCancellable.add(() -> {
            if (!this.invokeListenerPostCancel) {
                this.subscribers.remove(subscriber);
            }
        });
        if (!this.deferOnSubscribe) {
            subscriber.onSubscribe((Cancellable)this.dynamicCancellable);
        }
        if (this.terminalNotification != null) {
            this.subscribers.remove(subscriber);
            this.terminalNotification.terminate(subscriber);
        }
    }

    public void sendOnSubscribe() {
        assert (this.deferOnSubscribe);
        this.deferOnSubscribe = false;
        this.subscribers.forEach(s -> s.onSubscribe((Cancellable)this.dynamicCancellable));
    }

    public void onSubscribe(Cancellable cancellable) {
        this.dynamicCancellable.add(cancellable);
    }

    public synchronized void onComplete() {
        for (CompletableSource.Subscriber subscriber : this.subscribers) {
            subscriber.onComplete();
        }
        this.subscribers.clear();
        this.terminalNotification = TerminalNotification.complete();
    }

    public synchronized void onError(Throwable t) {
        for (CompletableSource.Subscriber subscriber : this.subscribers) {
            subscriber.onError(t);
        }
        this.subscribers.clear();
        this.terminalNotification = TerminalNotification.error((Throwable)t);
    }

    public boolean isCancelled() {
        return this.dynamicCancellable.isCancelled();
    }

    public LegacyTestCompletable verifyListenCalled() {
        MatcherAssert.assertThat((String)"Listen not called.", this.subscribers, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        return this;
    }

    public LegacyTestCompletable verifyListenNotCalled() {
        MatcherAssert.assertThat((String)"Listen called.", this.subscribers, (Matcher)Matchers.hasSize((int)0));
        return this;
    }

    public LegacyTestCompletable verifyCancelled() {
        Assert.assertTrue((String)"Subscriber did not cancel.", (boolean)this.isCancelled());
        return this;
    }

    public LegacyTestCompletable verifyNotCancelled() {
        Assert.assertFalse((String)"Subscriber cancelled.", (boolean)this.isCancelled());
        return this;
    }
}

