/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import java.util.concurrent.atomic.AtomicLong;

public final class DemandCheckingSubscriber<T>
implements PublisherSource.Subscriber<T> {
    private static final long NO_ON_SUBSCRIBE = Long.MIN_VALUE;
    private final PublisherSource.Subscriber<? super T> delegate;
    private final AtomicLong pending = new AtomicLong(Long.MIN_VALUE);

    public DemandCheckingSubscriber(PublisherSource.Subscriber<? super T> delegate) {
        this.delegate = delegate;
    }

    public void onSubscribe(final PublisherSource.Subscription s) {
        this.pending.set(0L);
        this.delegate.onSubscribe(new PublisherSource.Subscription(){

            public void request(long n) {
                if (n == Long.MIN_VALUE) {
                    DemandCheckingSubscriber.this.pending.set(-9223372036854775807L);
                } else {
                    DemandCheckingSubscriber.this.pending.accumulateAndGet(n, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                }
                s.request(n);
            }

            public void cancel() {
                s.cancel();
            }
        });
    }

    public void onNext(T t) {
        long pending = this.pending.getAndAccumulate(-1L, FlowControlUtils::addWithOverflowProtectionIfPositive);
        if (pending <= 0L) {
            if (pending == Long.MIN_VALUE) {
                throw new AssertionError((Object)("Demand check failure: No subscription available to check demand. Ignoring item: " + t));
            }
            throw new AssertionError((Object)("Demand check failure: Invalid outstanding demand " + pending + ". Ignoring item: " + t));
        }
        this.delegate.onNext(t);
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }
}

