/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public final class ConcurrentSingleSubscriberFunction<T>
implements Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> {
    private final List<SingleSource.Subscriber<? super T>> subscribers = new CopyOnWriteArrayList<SingleSource.Subscriber<? super T>>();
    private final SingleSource.Subscriber<T> listSubscriber = new SingleSource.Subscriber<T>(){

        public void onSubscribe(Cancellable c) {
            for (SingleSource.Subscriber subscriber : ConcurrentSingleSubscriberFunction.this.subscribers) {
                subscriber.onSubscribe(c);
            }
        }

        public void onSuccess(T result) {
            for (SingleSource.Subscriber subscriber : ConcurrentSingleSubscriberFunction.this.subscribers) {
                subscriber.onSuccess(result);
            }
        }

        public void onError(Throwable t) {
            for (SingleSource.Subscriber subscriber : ConcurrentSingleSubscriberFunction.this.subscribers) {
                subscriber.onError(t);
            }
        }
    };

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribers.add(subscriber);
        return this.listSubscriber;
    }

    public List<SingleSource.Subscriber<? super T>> subscribers() {
        return new ArrayList<SingleSource.Subscriber<? super T>>(this.subscribers);
    }
}

